/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.integration.plugin.CreatePluginHandler;
import com.epam.ta.reportportal.core.integration.plugin.DeletePluginHandler;
import com.epam.ta.reportportal.core.integration.plugin.GetPluginHandler;
import com.epam.ta.reportportal.core.integration.plugin.UpdatePluginHandler;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.integration.IntegrationTypeResource;
import com.epam.ta.reportportal.ws.model.integration.UpdatePluginStateRQ;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/plugin"})
public class PluginController {
    private final CreatePluginHandler createPluginHandler;
    private final UpdatePluginHandler updatePluginHandler;
    private final GetPluginHandler getPluginHandler;
    private final DeletePluginHandler deletePluginHandler;

    @Autowired
    public PluginController(CreatePluginHandler createPluginHandler, UpdatePluginHandler updatePluginHandler, GetPluginHandler getPluginHandler, DeletePluginHandler deletePluginHandler) {
        this.createPluginHandler = createPluginHandler;
        this.updatePluginHandler = updatePluginHandler;
        this.getPluginHandler = getPluginHandler;
        this.deletePluginHandler = deletePluginHandler;
    }

    @Transactional
    @PostMapping(consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Upload new Report Portal plugin")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public EntryCreatedRS uploadPlugin(@NotNull @RequestParam(value="file") MultipartFile pluginFile, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createPluginHandler.uploadPlugin(pluginFile);
    }

    @Transactional
    @PutMapping(value={"/{pluginId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update Report Portal plugin state")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public OperationCompletionRS updatePluginState(@PathVariable(value="pluginId") Long id, @RequestBody @Valid UpdatePluginStateRQ updatePluginStateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updatePluginHandler.updatePluginState(id, updatePluginStateRQ);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all available plugins")
    public List<IntegrationTypeResource> getPlugins(@AuthenticationPrincipal ReportPortalUser user) {
        return this.getPluginHandler.getPlugins();
    }

    @Transactional
    @DeleteMapping(value={"/{pluginId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete plugin by id")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public OperationCompletionRS deletePlugin(@PathVariable(value="pluginId") Long id, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deletePluginHandler.deleteById(id);
    }
}

