/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.imprt.ImportLaunchHandler;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.launch.DeleteLaunchHandler;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.core.launch.MergeLaunchHandler;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.core.launch.StopLaunchHandler;
import com.epam.ta.reportportal.core.launch.UpdateLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LinkGenerator;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.widget.content.ChartStatisticsContent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.BulkInfoUpdateRQ;
import com.epam.ta.reportportal.ws.model.BulkRQ;
import com.epam.ta.reportportal.ws.model.DeleteBulkRQ;
import com.epam.ta.reportportal.ws.model.DeleteBulkRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.Page;
import com.epam.ta.reportportal.ws.model.launch.AnalyzeLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.FinishLaunchRS;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import com.epam.ta.reportportal.ws.model.launch.UpdateLaunchRQ;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/{projectName}/launch"})
public class LaunchController {
    private final StartLaunchHandler startLaunchHandler;
    private final FinishLaunchHandler finishLaunchHandler;
    private final StopLaunchHandler stopLaunchHandler;
    private final DeleteLaunchHandler deleteLaunchMessageHandler;
    private final GetLaunchHandler getLaunchMessageHandler;
    private final UpdateLaunchHandler updateLaunchHandler;
    private final MergeLaunchHandler mergeLaunchesHandler;
    private final ImportLaunchHandler importLaunchHandler;
    private final GetJasperReportHandler<Launch> getJasperHandler;

    public LaunchController(StartLaunchHandler startLaunchHandler, FinishLaunchHandler finishLaunchHandler, StopLaunchHandler stopLaunchHandler, DeleteLaunchHandler deleteLaunchMessageHandler, GetLaunchHandler getLaunchMessageHandler, UpdateLaunchHandler updateLaunchHandler, MergeLaunchHandler mergeLaunchesHandler, ImportLaunchHandler importLaunchHandler, @Qualifier(value="launchJasperReportHandler") GetJasperReportHandler<Launch> getJasperHandler) {
        this.startLaunchHandler = startLaunchHandler;
        this.finishLaunchHandler = finishLaunchHandler;
        this.stopLaunchHandler = stopLaunchHandler;
        this.deleteLaunchMessageHandler = deleteLaunchMessageHandler;
        this.getLaunchMessageHandler = getLaunchMessageHandler;
        this.updateLaunchHandler = updateLaunchHandler;
        this.mergeLaunchesHandler = mergeLaunchesHandler;
        this.importLaunchHandler = importLaunchHandler;
        this.getJasperHandler = getJasperHandler;
    }

    @PostMapping
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Starts launch for specified project")
    public StartLaunchRS startLaunch(@PathVariable String projectName, @ApiParam(value="Start launch request body", required=true) @RequestBody @Validated @Valid StartLaunchRQ startLaunchRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.startLaunchHandler.startLaunch(user, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), startLaunchRQ);
    }

    @PutMapping(value={"/{launchId}/finish"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Finish launch for specified project")
    public FinishLaunchRS finishLaunch(@PathVariable String projectName, @PathVariable String launchId, @RequestBody @Validated FinishExecutionRQ finishLaunchRQ, @AuthenticationPrincipal ReportPortalUser user, HttpServletRequest request) {
        return this.finishLaunchHandler.finishLaunch(launchId, finishLaunchRQ, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, LinkGenerator.composeBaseUrl(request));
    }

    @Transactional
    @PutMapping(value={"/{launchId}/stop"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Force finish launch for specified project")
    public OperationCompletionRS forceFinishLaunch(@PathVariable String projectName, @PathVariable Long launchId, @RequestBody @Validated FinishExecutionRQ finishExecutionRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.stopLaunchHandler.stopLaunch(launchId, finishExecutionRQ, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional
    @PutMapping(value={"/stop"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Force finish launch")
    public List<OperationCompletionRS> bulkForceFinish(@PathVariable String projectName, @RequestBody @Validated BulkRQ<Long, FinishExecutionRQ> rq, @AuthenticationPrincipal ReportPortalUser user) {
        return this.stopLaunchHandler.stopLaunch(rq, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional
    @PutMapping(value={"/{launchId}/update"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Updates launch for specified project")
    public OperationCompletionRS updateLaunch(@PathVariable String projectName, @PathVariable Long launchId, @RequestBody @Validated UpdateLaunchRQ updateLaunchRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.updateLaunch(launchId, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, updateLaunchRQ);
    }

    @Transactional
    @PutMapping(value={"/update"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Updates launches for specified project")
    public List<OperationCompletionRS> updateLaunches(@PathVariable String projectName, @RequestBody @Validated BulkRQ<Long, UpdateLaunchRQ> rq, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.updateLaunch(rq, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional
    @DeleteMapping(value={"/{launchId}"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete specified launch by ID")
    public OperationCompletionRS deleteLaunch(@PathVariable String projectName, @PathVariable Long launchId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteLaunchMessageHandler.deleteLaunch(launchId, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{launchId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get specified launch by ID")
    public LaunchResource getLaunch(@PathVariable String projectName, @PathVariable String launchId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLaunch(launchId, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/uuid/{launchId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get specified launch by UUID")
    public LaunchResource getLaunchByUuid(@PathVariable String projectName, @PathVariable String launchId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLaunch(launchId, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)));
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of project launches by filter")
    public Iterable<LaunchResource> getProjectLaunches(@PathVariable String projectName, @FilterFor(value=Launch.class) Filter filter, @SortFor(value=Launch.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getProjectLaunches(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), filter, pageable, user.getUsername());
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/latest"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of latest project launches by filter")
    public Page<LaunchResource> getLatestLaunches(@PathVariable String projectName, @FilterFor(value=Launch.class) Filter filter, @SortFor(value=Launch.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLatestLaunches(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), filter, pageable);
    }

    @GetMapping(value={"/mode"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get launches of specified project from DEBUG mode")
    public Iterable<LaunchResource> getDebugLaunches(@PathVariable String projectName, @FilterFor(value=Launch.class) Filter filter, @SortFor(value=Launch.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getDebugLaunches(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), filter, pageable);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/keys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique attribute keys of project launches")
    public List<String> getAttributeKeys(@PathVariable String projectName, @RequestParam(value="filter.cnt.attributeKey") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getAttributeKeys(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), value);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/values"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique attribute values of project launches")
    public List<String> getAttributeValues(@PathVariable String projectName, @RequestParam(value="filter.eq.attributeKey", required=false) String key, @RequestParam(value="filter.cnt.attributeValue") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getAttributeValues(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), key, value);
    }

    @Transactional
    @PutMapping(value={"/info"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Bulk update attributes and description")
    public OperationCompletionRS bulkUpdate(@PathVariable String projectName, @RequestBody @Validated BulkInfoUpdateRQ bulkInfoUpdateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.bulkInfoUpdate(bulkInfoUpdateRQ, ProjectExtractor.extractProjectDetails(user, projectName));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/owners"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique owners of project launches")
    public List<String> getAllOwners(@PathVariable String projectName, @RequestParam(value="filter.cnt.user") String value, @RequestParam(value="mode", required=false, defaultValue="DEFAULT") String mode, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getOwners(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), value, mode);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/names"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get launch names of project")
    public List<String> getAllLaunchNames(@PathVariable String projectName, @RequestParam(value="filter.cnt.name") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLaunchNames(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), value);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/compare"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Compare launches")
    public Map<String, List<ChartStatisticsContent>> compareLaunches(@PathVariable String projectName, @RequestParam(value="ids") Long[] ids, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLaunchesComparisonInfo(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), ids);
    }

    @Transactional
    @PostMapping(value={"/merge"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Merge set of specified launches in common one")
    public LaunchResource mergeLaunches(@PathVariable String projectName, @ApiParam(value="Merge launches request body", required=true) @RequestBody @Validated MergeLaunchesRQ mergeLaunchesRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.mergeLaunchesHandler.mergeLaunches(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, mergeLaunchesRQ);
    }

    @Transactional
    @PostMapping(value={"/analyze"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Start launch auto-analyzer on demand")
    public OperationCompletionRS startLaunchAnalyzer(@PathVariable String projectName, @RequestBody @Validated AnalyzeLaunchRQ analyzeLaunchRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.startLaunchAnalyzer(analyzeLaunchRQ, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/status"})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, String> getStatuses(@PathVariable String projectName, @RequestParam(value="ids") Long[] ids, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getStatuses(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), ids);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{launchId}/report"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Export specified launch", notes="Only following formats are supported: pdf (by default), xls, html.")
    public void getLaunchReport(@PathVariable String projectName, @PathVariable Long launchId, @ApiParam(allowableValues="pdf, xls, html") @RequestParam(value="view", required=false, defaultValue="pdf") String view, @AuthenticationPrincipal ReportPortalUser user, HttpServletResponse response) {
        ReportFormat format = this.getJasperHandler.getReportFormat(view);
        response.setContentType(format.getContentType());
        response.setHeader("Content-Disposition", String.format("attachment; filename=RP_LAUNCH_%s_Report.%s", format.name(), format.getValue()));
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.getLaunchMessageHandler.exportLaunch(launchId, format, (OutputStream)outputStream, user);
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to write data to the response."});
        }
    }

    @Transactional
    @DeleteMapping
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete specified launches by ids")
    public DeleteBulkRS deleteLaunches(@PathVariable String projectName, @RequestBody @Valid DeleteBulkRQ deleteBulkRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteLaunchMessageHandler.deleteLaunches(deleteBulkRQ, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @PostMapping(value={"/import"}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Import junit xml report", notes="Only following formats are supported: zip.")
    public OperationCompletionRS importLaunch(@PathVariable String projectName, @RequestParam(value="file") MultipartFile file, @AuthenticationPrincipal ReportPortalUser user, HttpServletRequest request) {
        return this.importLaunchHandler.importLaunch(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, "XUNIT", file, LinkGenerator.composeBaseUrl(request));
    }
}

