/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ControllerUtils {
    public static MultipartFile findByFileName(String filename, Map<String, MultipartFile> files) {
        if (files.containsKey(filename)) {
            return files.get(filename);
        }
        for (MultipartFile file : files.values()) {
            if (!filename.equals(file.getOriginalFilename())) continue;
            return file;
        }
        return null;
    }

    public static void validateSaveRQ(Validator validator, SaveLogRQ saveLogRQ) {
        Set constraintViolations = validator.validate((Object)saveLogRQ, new Class[0]);
        if (constraintViolations != null && !constraintViolations.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder();
            for (ConstraintViolation constraintViolation : constraintViolations) {
                messageBuilder.append("[");
                messageBuilder.append("Incorrect value in save log request '");
                messageBuilder.append(constraintViolation.getInvalidValue());
                messageBuilder.append("' in field '");
                Iterator iterator = constraintViolation.getPropertyPath().iterator();
                messageBuilder.append(iterator.hasNext() ? ((Path.Node)iterator.next()).getName() : "");
                messageBuilder.append("'.]");
            }
            throw new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{messageBuilder.toString()});
        }
    }

    public static Map<String, MultipartFile> getUploadedFiles(HttpServletRequest request) {
        HashMap<String, MultipartFile> uploadedFiles = new HashMap<String, MultipartFile>();
        if (request instanceof MultipartHttpServletRequest) {
            MultiValueMap multiFileMap = ((MultipartHttpServletRequest)request).getMultiFileMap();
            for (List multipartFiles : multiFileMap.values()) {
                for (MultipartFile file : multipartFiles) {
                    uploadedFiles.put(file.getOriginalFilename(), file);
                }
            }
        }
        return uploadedFiles;
    }
}

