/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job.service.impl;

import com.epam.reportportal.extension.common.IntegrationTypeProperties;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.core.plugin.PluginInfo;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.enums.ReservedIntegrationTypeEnum;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.job.service.PluginLoaderService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PluginLoaderServiceImpl
implements PluginLoaderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginLoaderServiceImpl.class);
    private final IntegrationTypeRepository integrationTypeRepository;
    private final Pf4jPluginBox pluginBox;

    @Autowired
    public PluginLoaderServiceImpl(IntegrationTypeRepository integrationTypeRepository, Pf4jPluginBox pluginBox) {
        this.integrationTypeRepository = integrationTypeRepository;
        this.pluginBox = pluginBox;
    }

    @Override
    public List<PluginInfo> getNotLoadedPluginsInfo() {
        LOGGER.debug("Searching for not loaded plugins...");
        ArrayList notLoadedPlugins = Lists.newArrayList();
        this.integrationTypeRepository.findAll().stream().filter(IntegrationType::isEnabled).filter(it -> it.getDetails() != null && it.getDetails().getDetails() != null).filter(this::isMandatoryFieldsExist).forEach(it -> {
            Map<IntegrationTypeProperties, Object> pluginProperties = this.retrievePluginProperties((IntegrationType)it);
            Optional<PluginWrapper> pluginWrapper = this.pluginBox.getPluginById(it.getName());
            if (pluginWrapper.isEmpty() || !String.valueOf(pluginProperties.get(IntegrationTypeProperties.VERSION)).equalsIgnoreCase(pluginWrapper.get().getDescriptor().getVersion())) {
                PluginInfo pluginInfo = new PluginInfo(it.getName(), String.valueOf(pluginProperties.get(IntegrationTypeProperties.VERSION)), String.valueOf(pluginProperties.get(IntegrationTypeProperties.FILE_ID)), String.valueOf(pluginProperties.get(IntegrationTypeProperties.FILE_NAME)), it.isEnabled());
                notLoadedPlugins.add(pluginInfo);
            }
        });
        LOGGER.debug((String)Suppliers.formattedSupplier((String)"{} not loaded plugins have been found", (Object[])new Object[]{notLoadedPlugins.size()}).get());
        return notLoadedPlugins;
    }

    @Override
    @Transactional
    public void checkAndDeleteIntegrationType(IntegrationType integrationType) {
        if (this.isIntegrationTypeAvailableForRemoving(integrationType)) {
            this.integrationTypeRepository.deleteById((Object)integrationType.getId());
        }
    }

    private boolean isMandatoryFieldsExist(IntegrationType integrationType) {
        Map details = integrationType.getDetails().getDetails();
        return Stream.of(IntegrationTypeProperties.FILE_ID, IntegrationTypeProperties.VERSION, IntegrationTypeProperties.FILE_NAME).allMatch(property -> property.getValue(details).isPresent());
    }

    private Map<IntegrationTypeProperties, Object> retrievePluginProperties(IntegrationType integrationType) {
        Map details = integrationType.getDetails().getDetails();
        HashMap pluginProperties = Maps.newHashMapWithExpectedSize((int)IntegrationTypeProperties.values().length);
        Arrays.stream(IntegrationTypeProperties.values()).forEach(property -> property.getValue(details).ifPresent(value -> pluginProperties.put(property, value)));
        return pluginProperties;
    }

    private boolean isIntegrationTypeAvailableForRemoving(IntegrationType integrationType) {
        if (ReservedIntegrationTypeEnum.fromName((String)integrationType.getName()).isPresent()) {
            return false;
        }
        return this.pluginBox.getPluginById(integrationType.getName()).map(p -> {
            if (this.pluginBox.unloadPlugin(integrationType)) {
                try {
                    Files.deleteIfExists(p.getPluginPath());
                    return true;
                }
                catch (IOException ex) {
                    LOGGER.error("Error has occurred during plugin removing from the root directory", (Throwable)ex);
                    return false;
                }
            }
            return false;
        }).orElse(true);
    }
}

