/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job.service.impl;

import com.epam.ta.reportportal.binary.DataStoreService;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.entity.attachment.Attachment;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.AttachmentCleanerService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AttachmentCleanerServiceImpl
implements AttachmentCleanerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentCleanerServiceImpl.class);
    private final Integer attachmentsPageSize;
    private final AttachmentRepository attachmentRepository;
    private final DataStoreService dataStoreService;

    @Autowired
    public AttachmentCleanerServiceImpl(@Value(value="${rp.environment.variable.clean.attach.size}") Integer attachmentsPageSize, AttachmentRepository attachmentRepository, @Qualifier(value="attachmentDataStoreService") DataStoreService dataStoreService) {
        this.attachmentsPageSize = attachmentsPageSize;
        this.attachmentRepository = attachmentRepository;
        this.dataStoreService = dataStoreService;
    }

    @Override
    public void removeOutdatedItemsAttachments(Collection<Long> itemIds, LocalDateTime before, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        List attachments = this.attachmentRepository.findByItemIdsAndLogTimeBefore(itemIds, before);
        this.removeAttachments(attachments, attachmentsCount, thumbnailsCount);
    }

    @Override
    public void removeLaunchAttachments(Long launchId, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        List attachments = this.attachmentRepository.findAllByLaunchIdIn(Collections.singletonList(launchId));
        this.removeAttachments(attachments, attachmentsCount, thumbnailsCount);
    }

    @Override
    public void removeOutdatedLaunchesAttachments(Collection<Long> launchIds, LocalDateTime before, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        List launchAttachments = this.attachmentRepository.findByLaunchIdsAndLogTimeBefore(launchIds, before);
        this.removeAttachments(launchAttachments, attachmentsCount, thumbnailsCount);
    }

    @Override
    public void removeProjectAttachments(Project project, LocalDateTime before, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        AtomicLong notRemoved = new AtomicLong(0L);
        PageUtil.iterateOverContent(this.attachmentsPageSize, pageable -> this.attachmentRepository.findByProjectIdsAndLogTimeBefore(project.getId(), before, pageable.getPageSize(), notRemoved.get()), attachments -> {
            int removedCount = this.removeAttachments((Collection<Attachment>)attachments, attachmentsCount, thumbnailsCount);
            notRemoved.addAndGet(attachments.size() - removedCount);
        });
    }

    private int removeAttachments(Collection<Attachment> attachments, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        ArrayList attachmentIds = new ArrayList();
        attachments.forEach(it -> {
            try {
                Optional.ofNullable(it).ifPresent(attachment -> {
                    Optional.ofNullable(attachment.getFileId()).ifPresent(fileId -> {
                        this.dataStoreService.delete(fileId);
                        attachmentsCount.addAndGet(1L);
                    });
                    Optional.ofNullable(attachment.getThumbnailId()).ifPresent(thumbnailId -> {
                        this.dataStoreService.delete(thumbnailId);
                        thumbnailsCount.addAndGet(1L);
                    });
                    attachmentIds.add(attachment.getId());
                });
            }
            catch (Exception ex) {
                LOGGER.debug("Error has occurred during the attachments removing", (Throwable)ex);
            }
        });
        if (CollectionUtils.isNotEmpty(attachmentIds)) {
            this.attachmentRepository.deleteAllByIds(attachmentIds);
        }
        return attachmentIds.size();
    }
}

