/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.demodata.model.DemoDataRq;
import com.epam.ta.reportportal.demodata.model.DemoDataRs;
import com.epam.ta.reportportal.demodata.service.DemoDataService;
import com.epam.ta.reportportal.util.ProjectExtractor;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/demo/{projectName}"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
class DemoDataController {
    private final DemoDataService demoDataService;
    private final ProjectExtractor projectExtractor;

    DemoDataController(DemoDataService demoDataService, ProjectExtractor projectExtractor) {
        this.demoDataService = demoDataService;
        this.projectExtractor = projectExtractor;
    }

    @PostMapping
    @ApiOperation(value="generate")
    public DemoDataRs generate(@PathVariable String projectName, @Validated @RequestBody DemoDataRq demoDataRq, @AuthenticationPrincipal ReportPortalUser user) {
        return this.demoDataService.generate(demoDataRq, this.projectExtractor.extractProjectDetailsAdmin(user, projectName), user);
    }
}

