/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.WidgetUpdatedEvent;
import com.epam.ta.reportportal.core.filter.UpdateUserFilterHandler;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.core.widget.UpdateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.updater.validator.WidgetValidator;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.activity.WidgetActivityResource;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class UpdateWidgetHandlerImpl
implements UpdateWidgetHandler {
    private final UpdateUserFilterHandler updateUserFilterHandler;
    private final WidgetRepository widgetRepository;
    private final UserFilterRepository filterRepository;
    private final MessageBus messageBus;
    private final ObjectMapper objectMapper;
    private final GetShareableEntityHandler<Widget> getShareableEntityHandler;
    private final ShareableObjectsHandler aclHandler;
    private final WidgetValidator widgetContentFieldsValidator;

    @Autowired
    public UpdateWidgetHandlerImpl(UpdateUserFilterHandler updateUserFilterHandler, WidgetRepository widgetRepository, UserFilterRepository filterRepository, MessageBus messageBus, ObjectMapper objectMapper, GetShareableEntityHandler<Widget> getShareableEntityHandler, ShareableObjectsHandler aclHandler, WidgetValidator widgetContentFieldsValidator) {
        this.updateUserFilterHandler = updateUserFilterHandler;
        this.widgetRepository = widgetRepository;
        this.filterRepository = filterRepository;
        this.messageBus = messageBus;
        this.objectMapper = objectMapper;
        this.getShareableEntityHandler = getShareableEntityHandler;
        this.aclHandler = aclHandler;
        this.widgetContentFieldsValidator = widgetContentFieldsValidator;
    }

    @Override
    public OperationCompletionRS updateWidget(Long widgetId, WidgetRQ updateRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Widget widget = this.getShareableEntityHandler.getAdministrated(widgetId, projectDetails);
        this.widgetContentFieldsValidator.validate(widget);
        if (!widget.getName().equals(updateRQ.getName())) {
            BusinessRule.expect((Object)this.widgetRepository.existsByNameAndOwnerAndProjectId(updateRQ.getName(), user.getUsername(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{updateRQ.getName()});
        }
        WidgetActivityResource before = WidgetConverter.TO_ACTIVITY_RESOURCE.apply(widget);
        List<UserFilter> userFilter = this.getUserFilters(updateRQ.getFilterIds(), projectDetails.getProjectId(), user.getUsername());
        String widgetOptionsBefore = this.parseWidgetOptions(widget);
        this.updateSharing(widget, projectDetails.getProjectId(), updateRQ.getShare());
        widget = new WidgetBuilder(widget).addWidgetRq(updateRQ).addFilters(userFilter).get();
        this.widgetRepository.save((Object)widget);
        this.messageBus.publishActivity(new WidgetUpdatedEvent(before, WidgetConverter.TO_ACTIVITY_RESOURCE.apply(widget), widgetOptionsBefore, this.parseWidgetOptions(widget), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' successfully updated.");
    }

    @Override
    public void updateSharing(Collection<Widget> widgets, Long projectId, Boolean isShared) {
        widgets.forEach(widget -> this.updateSharing((Widget)widget, projectId, isShared));
    }

    private void updateSharing(Widget widget, Long projectId, Boolean shared) {
        if (null != shared) {
            if (shared.booleanValue() != widget.isShared()) {
                widget.setShared(shared.booleanValue());
                this.aclHandler.updateAcl(widget, projectId, widget.isShared());
            }
            if (widget.isShared()) {
                Optional.ofNullable(widget.getFilters()).ifPresent(filters -> this.updateUserFilterHandler.updateSharing((Collection<UserFilter>)filters, projectId, widget.isShared()));
            }
        }
    }

    private List<UserFilter> getUserFilters(List<Long> filterIds, Long projectId, String username) {
        if (CollectionUtils.isNotEmpty(filterIds)) {
            Filter defaultFilter = new Filter(UserFilter.class, Condition.IN, false, filterIds.stream().map(String::valueOf).collect(Collectors.joining(",")), "id");
            return this.filterRepository.getPermitted(ProjectFilter.of((Queryable)defaultFilter, (Long)projectId), Pageable.unpaged(), username).getContent();
        }
        return Collections.emptyList();
    }

    private String parseWidgetOptions(Widget widget) {
        try {
            return this.objectMapper.writeValueAsString((Object)widget.getWidgetOptions());
        }
        catch (JsonProcessingException e) {
            throw new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Error during parsing new widget options of widget with id = ", (Object[])new Object[]{widget.getId()})});
        }
    }
}

