/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.remover;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.Lists;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class MaterializedViewContentRemover
implements WidgetContentRemover {
    private final WidgetContentRepository widgetContentRepository;

    public MaterializedViewContentRemover(WidgetContentRepository widgetContentRepository) {
        this.widgetContentRepository = widgetContentRepository;
    }

    @Override
    public void removeContent(Widget widget) {
        if (this.supports(widget)) {
            this.validateState(widget.getWidgetOptions());
            Optional.ofNullable(WidgetOptionUtil.getValueByKey("viewName", widget.getWidgetOptions())).ifPresent(arg_0 -> ((WidgetContentRepository)this.widgetContentRepository).removeWidgetView(arg_0));
        }
    }

    @Override
    public boolean supports(Widget widget) {
        return Lists.newArrayList((Object[])new String[]{WidgetType.COMPONENT_HEALTH_CHECK_TABLE.getType(), WidgetType.CUMULATIVE.getType()}).contains(widget.getWidgetType());
    }

    private void validateState(WidgetOptions widgetOptions) {
        WidgetState widgetState = (WidgetState)Optional.ofNullable(WidgetOptionUtil.getValueByKey("state", widgetOptions)).flatMap(WidgetState::findByName).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_UPDATE_WIDGET_REQUEST, new Object[]{"Widget state not provided"}));
        BusinessRule.expect((Object)widgetState, it -> !WidgetState.RENDERING.equals(it)).verify(ErrorType.BAD_UPDATE_WIDGET_REQUEST, new Object[]{"Unable to remove widget in 'rendering' state"});
    }
}

