/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.querygen.CompositeFilterCondition;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.MultilevelLoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class ComponentHealthCheckContentLoader
implements MultilevelLoadContentStrategy {
    public static final Integer MAX_LEVEL_NUMBER = 10;
    private final WidgetContentRepository widgetContentRepository;

    @Autowired
    public ComponentHealthCheckContentLoader(WidgetContentRepository widgetContentRepository) {
        this.widgetContentRepository = widgetContentRepository;
    }

    @Override
    public Map<String, Object> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, String[] attributes, MultiValueMap<String, String> params, int limit) {
        List<String> attributeKeys = WidgetOptionUtil.getListByKey("attributeKeys", widgetOptions);
        List attributeValues = Optional.ofNullable(attributes).map(Arrays::asList).orElseGet(Collections::emptyList);
        int currentLevel = attributeValues.size();
        BusinessRule.expect(attributeKeys, keys -> keys.size() > currentLevel).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Incorrect level definition"});
        Filter launchesFilter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort launchesSort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        boolean latestMode = WidgetOptionUtil.getBooleanByKey("latest", widgetOptions);
        Filter testItemFilter = Filter.builder().withTarget(TestItem.class).withCondition(this.getTestItemCondition(attributeKeys, attributeValues)).build();
        String currentLevelKey = attributeKeys.get(currentLevel);
        List content = this.widgetContentRepository.componentHealthCheck(launchesFilter, launchesSort, latestMode, limit, testItemFilter, currentLevelKey);
        return CollectionUtils.isNotEmpty((Collection)content) ? Collections.singletonMap("result", content) : Collections.emptyMap();
    }

    private ConvertibleCondition getTestItemCondition(List<String> attributeKeys, List<String> attributeValues) {
        ArrayList conditions = Lists.newArrayList((Object[])new ConvertibleCondition[]{FilterCondition.builder().eq("hasStats", String.valueOf(Boolean.TRUE)).build(), FilterCondition.builder().eq("hasChildren", String.valueOf(Boolean.FALSE)).build(), FilterCondition.builder().eq("type", TestItemTypeEnum.STEP.name()).build(), FilterCondition.builder().withCondition(Condition.EXISTS).withNegative(true).withSearchCriteria("retryParentId").withValue(String.valueOf(0L)).build(), FilterCondition.builder().withCondition(Condition.NOT_EQUALS).withNegative(false).withSearchCriteria("status").withValue(StatusEnum.IN_PROGRESS.name()).build()});
        if (CollectionUtils.isNotEmpty(attributeValues)) {
            String attributeCriteria = IntStream.range(0, attributeValues.size()).mapToObj(index -> {
                String attributeKey = (String)attributeKeys.get(index);
                String attributeValue = (String)attributeValues.get(index);
                return String.join((CharSequence)":", attributeKey, attributeValue);
            }).collect(Collectors.joining(","));
            conditions.add(FilterCondition.builder().withCondition(Condition.HAS).withNegative(false).withSearchCriteria("compositeAttribute").withValue(attributeCriteria).build());
        }
        return new CompositeFilterCondition((List)conditions);
    }
}

