/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.shareable.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.stereotype.Service;

@Service
public class GetShareableWidgetHandlerImpl
implements GetShareableEntityHandler<Widget> {
    private final WidgetRepository widgetRepository;

    @Autowired
    public GetShareableWidgetHandlerImpl(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'aclReadPermission') || hasPermission(returnObject, 'aclFullPermission') || hasRole('ADMINISTRATOR') || hasPermission(#projectDetails.getProjectName().toLowerCase(), 'projectManagerPermission')")
    public Widget getPermitted(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        return (Widget)this.widgetRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'aclFullPermission') || hasRole('ADMINISTRATOR') || hasPermission(#projectDetails.getProjectName().toLowerCase(), 'projectManagerPermission')")
    public Widget getAdministrated(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        return (Widget)this.widgetRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
    }
}

