/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.impl.LaunchPreparerService;
import com.epam.ta.reportportal.core.analyzer.config.AnalyzerType;
import com.epam.ta.reportportal.core.analyzer.strategy.LaunchAnalysisStrategy;
import com.epam.ta.reportportal.core.launch.UpdateLaunchHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ItemInfoUtils;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.converters.ItemAttributeConverter;
import com.epam.ta.reportportal.ws.model.BulkInfoUpdateRQ;
import com.epam.ta.reportportal.ws.model.BulkRQ;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.ws.model.launch.AnalyzeLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.UpdateLaunchRQ;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateLaunchHandlerImpl
implements UpdateLaunchHandler {
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final ProjectRepository projectRepository;
    private final LogIndexer logIndexer;
    private final LaunchPreparerService launchPreparerService;
    private final Map<AnalyzerType, LaunchAnalysisStrategy> launchAnalysisStrategyMapping;

    @Autowired
    public UpdateLaunchHandlerImpl(LaunchRepository launchRepository, TestItemRepository testItemRepository, LogRepository logRepository, ProjectRepository projectRepository, LogIndexer logIndexer, LaunchPreparerService launchPreparerService, Map<AnalyzerType, LaunchAnalysisStrategy> launchAnalysisStrategyMapping) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.projectRepository = projectRepository;
        this.launchAnalysisStrategyMapping = launchAnalysisStrategyMapping;
        this.logIndexer = logIndexer;
        this.launchPreparerService = launchPreparerService;
    }

    @Override
    public OperationCompletionRS updateLaunch(Long launchId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, UpdateLaunchRQ rq) {
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectName()}));
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId.toString()}));
        this.validate(launch, user, projectDetails, rq.getMode());
        LaunchModeEnum previousMode = launch.getMode();
        launch = new LaunchBuilder(launch).addMode(rq.getMode()).addDescription(rq.getDescription()).overwriteAttributes(rq.getAttributes()).get();
        this.launchRepository.save((Object)launch);
        if (!previousMode.equals((Object)launch.getMode())) {
            this.reindexLogs(launch, AnalyzerUtils.getAnalyzerConfig(project), project.getId());
        }
        return new OperationCompletionRS("Launch with ID = '" + launch.getId() + "' successfully updated.");
    }

    @Override
    public List<OperationCompletionRS> updateLaunch(BulkRQ<Long, UpdateLaunchRQ> rq, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        return rq.getEntities().entrySet().stream().map(entry -> this.updateLaunch((Long)entry.getKey(), projectDetails, user, (UpdateLaunchRQ)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public OperationCompletionRS startLaunchAnalyzer(AnalyzeLaunchRQ analyzeRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        AnalyzerType analyzerType = AnalyzerType.fromString(analyzeRQ.getAnalyzerTypeName());
        this.launchAnalysisStrategyMapping.get((Object)analyzerType).analyze(analyzeRQ, projectDetails, user);
        return new OperationCompletionRS(analyzerType.getName() + " analysis for launch with ID='" + analyzeRQ.getLaunchId() + "' started.");
    }

    @Override
    public OperationCompletionRS bulkInfoUpdate(BulkInfoUpdateRQ bulkUpdateRq, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)this.projectRepository.existsById((Object)projectDetails.getProjectId()), Predicate.isEqual(true)).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()});
        List launches = this.launchRepository.findAllById((Iterable)bulkUpdateRq.getIds());
        launches.forEach(it -> ItemInfoUtils.updateDescription(bulkUpdateRq.getDescription(), it.getDescription()).ifPresent(arg_0 -> ((Launch)it).setDescription(arg_0)));
        bulkUpdateRq.getAttributes().forEach(it -> {
            switch (it.getAction()) {
                case DELETE: {
                    launches.forEach(launch -> {
                        ItemAttribute toDelete = ItemInfoUtils.findAttributeByResource(launch.getAttributes(), it.getFrom());
                        launch.getAttributes().remove(toDelete);
                    });
                    break;
                }
                case UPDATE: {
                    launches.forEach(launch -> ItemInfoUtils.updateAttribute(launch.getAttributes(), it));
                    break;
                }
                case CREATE: {
                    launches.stream().filter(launch -> ItemInfoUtils.containsAttribute(launch.getAttributes(), it.getTo())).forEach(launch -> {
                        ItemAttribute itemAttribute = ItemAttributeConverter.FROM_RESOURCE.apply(it.getTo());
                        itemAttribute.setLaunch(launch);
                        launch.getAttributes().add(itemAttribute);
                    });
                }
            }
        });
        return new OperationCompletionRS("Attributes successfully updated");
    }

    private void reindexLogs(Launch launch, AnalyzerConfig analyzerConfig, Long projectId) {
        if (LaunchModeEnum.DEBUG.equals((Object)launch.getMode())) {
            this.logIndexer.cleanIndex(projectId, this.logRepository.findIdsUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launch.getId(), this.testItemRepository.selectIdsWithIssueByLaunch(launch.getId()), LogLevel.ERROR.toInt()));
        } else {
            List items = this.testItemRepository.findAllNotInIssueGroupByLaunch(launch.getId(), TestItemIssueGroup.TO_INVESTIGATE);
            this.launchPreparerService.prepare(launch, items, analyzerConfig).ifPresent(it -> this.logIndexer.indexPreparedLogs(projectId, (IndexLaunch)it));
        }
    }

    private void validate(Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, Mode mode) {
        if (projectDetails.getProjectRole() == ProjectRole.CUSTOMER && null != mode) {
            BusinessRule.expect((Object)mode, (Predicate)Predicates.equalTo((Object)Mode.DEFAULT)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            if (projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            }
        }
    }
}

