/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.LaunchDeletedEvent;
import com.epam.ta.reportportal.core.events.attachment.DeleteLaunchAttachmentsEvent;
import com.epam.ta.reportportal.core.launch.DeleteLaunchHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.model.DeleteBulkRQ;
import com.epam.ta.reportportal.ws.model.DeleteBulkRS;
import com.epam.ta.reportportal.ws.model.ErrorRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.activity.LaunchActivityResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteLaunchHandlerImpl
implements DeleteLaunchHandler {
    private final LaunchRepository launchRepository;
    private final LogRepository logRepository;
    private final MessageBus messageBus;
    private final LogIndexer logIndexer;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public DeleteLaunchHandlerImpl(LaunchRepository launchRepository, LogRepository logRepository, MessageBus messageBus, LogIndexer logIndexer, ApplicationEventPublisher eventPublisher) {
        this.launchRepository = launchRepository;
        this.logRepository = logRepository;
        this.messageBus = messageBus;
        this.logIndexer = logIndexer;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public OperationCompletionRS deleteLaunch(Long launchId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        this.validate(launch, user, projectDetails);
        this.logIndexer.cleanIndex(projectDetails.getProjectId(), this.logRepository.findItemLogIdsByLaunchIdAndLogLevelGte(launchId, LogLevel.ERROR.toInt()));
        this.launchRepository.delete((Object)launch);
        this.eventPublisher.publishEvent((Object)new DeleteLaunchAttachmentsEvent(launch.getId()));
        this.messageBus.publishActivity(new LaunchDeletedEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Launch with ID = '" + launchId + "' successfully deleted.");
    }

    @Override
    public DeleteBulkRS deleteLaunches(DeleteBulkRQ deleteBulkRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        ArrayList notFound = Lists.newArrayList();
        ArrayList exceptions = Lists.newArrayList();
        ArrayList toDelete = Lists.newArrayList();
        deleteBulkRQ.getIds().forEach(id -> {
            Optional optionalLaunch = this.launchRepository.findById(id);
            if (optionalLaunch.isPresent()) {
                Launch launch = (Launch)optionalLaunch.get();
                try {
                    this.validate(launch, user, projectDetails);
                    toDelete.add(launch);
                }
                catch (ReportPortalException ex) {
                    exceptions.add(ex);
                }
            } else {
                notFound.add(id);
            }
        });
        this.logIndexer.cleanIndex(projectDetails.getProjectId(), this.logRepository.findItemLogIdsByLaunchIdsAndLogLevelGte(toDelete.stream().map(Launch::getId).collect(Collectors.toList()), LogLevel.ERROR.toInt()));
        this.launchRepository.deleteAll((Iterable)toDelete);
        toDelete.stream().map(LaunchConverter.TO_ACTIVITY_RESOURCE).forEach(it -> {
            this.eventPublisher.publishEvent((Object)new DeleteLaunchAttachmentsEvent(it.getId()));
            this.messageBus.publishActivity(new LaunchDeletedEvent((LaunchActivityResource)it, user.getUserId(), user.getUsername()));
        });
        return new DeleteBulkRS(toDelete.stream().map(Launch::getId).collect(Collectors.toList()), (List)notFound, exceptions.stream().map(ex -> {
            ErrorRS errorResponse = new ErrorRS();
            errorResponse.setErrorType(ex.getErrorType());
            errorResponse.setMessage(ex.getMessage());
            return errorResponse;
        }).collect(Collectors.toList()));
    }

    private void validate(Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)launch, (Predicate)Predicates.not(l -> StatusEnum.IN_PROGRESS.equals((Object)l.getStatus()))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete launch '{}' in progress state", (Object[])new Object[]{launch.getId()})});
        if (!UserRole.ADMINISTRATOR.equals((Object)user.getUserRole())) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Target launch '{}' not under specified project '{}'", (Object[])new Object[]{launch.getId(), projectDetails.getProjectId()})});
            if (projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not launch owner."});
            }
        }
    }
}

