/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper.impl;

import com.epam.ta.reportportal.core.jasper.JasperReportRender;
import com.epam.ta.reportportal.core.jasper.impl.AbstractJasperReportHandler;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.jasper.ReportType;
import com.epam.ta.reportportal.entity.user.User;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userJasperReportHandler")
public class UserJasperReportHandler
extends AbstractJasperReportHandler<User> {
    private static final String UNSUPPORTED_REPORT_FORMAT_MESSAGE_EXCEPTION = "Report format - {} is not supported for user reports.";
    private final Set<ReportFormat> availableReportFormats;
    private final JasperReportRender reportRender;

    @Autowired
    public UserJasperReportHandler(JasperReportRender reportRender) {
        super(UNSUPPORTED_REPORT_FORMAT_MESSAGE_EXCEPTION);
        this.reportRender = reportRender;
        this.availableReportFormats = Sets.immutableEnumSet((Enum)ReportFormat.CSV, (Enum[])new ReportFormat[0]);
    }

    @Override
    public JasperPrint getJasperPrint(Map<String, Object> params, JRDataSource dataSource) {
        return this.reportRender.generateReportPrint(ReportType.USER, params, dataSource);
    }

    @Override
    public Map<String, Object> convertParams(User user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Full name", user.getFullName());
        params.put("Type", user.getUserType().name());
        params.put("Login", user.getLogin());
        params.put("Email", user.getEmail());
        params.put("Projects and Roles", user.getProjects().stream().collect(Collectors.toMap(projectUser -> projectUser.getProject().getName(), projectUser -> projectUser.getProjectRole().name(), (prev, curr) -> prev)).entrySet().stream().map(entry -> (String)entry.getKey() + " - " + (String)entry.getValue()).collect(Collectors.joining(", ")));
        Optional.ofNullable(user.getMetadata()).ifPresent(metadata -> Optional.ofNullable(metadata.getMetadata()).ifPresent(meta -> Optional.ofNullable(meta.get("last_login")).ifPresent(lastLogin -> {
            try {
                long epochMilli = Long.parseLong(String.valueOf(lastLogin));
                Instant instant = Instant.ofEpochMilli(epochMilli);
                params.put("Last login", DateTimeFormatter.ISO_ZONED_DATE_TIME.format(ZonedDateTime.ofInstant(instant, ZoneOffset.UTC)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        })));
        return params;
    }

    @Override
    public Set<ReportFormat> getAvailableReportFormats() {
        return this.availableReportFormats;
    }
}

