/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper.impl;

import com.epam.ta.reportportal.core.jasper.JasperReportRender;
import com.epam.ta.reportportal.core.jasper.impl.AbstractJasperReportHandler;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.jasper.ReportType;
import com.epam.ta.reportportal.entity.project.ProjectInfo;
import com.google.common.collect.Sets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectJasperReportHandler")
public class ProjectJasperReportHandler
extends AbstractJasperReportHandler<ProjectInfo> {
    private static final String UNSUPPORTED_REPORT_FORMAT_MESSAGE_EXCEPTION = "Report format - {} is not supported for project reports.";
    private final Set<ReportFormat> availableReportFormats;
    private final JasperReportRender reportRender;

    @Autowired
    public ProjectJasperReportHandler(JasperReportRender reportRender) {
        super(UNSUPPORTED_REPORT_FORMAT_MESSAGE_EXCEPTION);
        this.reportRender = reportRender;
        this.availableReportFormats = Sets.immutableEnumSet((Enum)ReportFormat.CSV, (Enum[])new ReportFormat[0]);
    }

    @Override
    public JasperPrint getJasperPrint(Map<String, Object> params, JRDataSource dataSource) {
        return this.reportRender.generateReportPrint(ReportType.PROJECT, params, dataSource);
    }

    @Override
    public Map<String, Object> convertParams(ProjectInfo project) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Project type", project.getProjectType());
        params.put("Project name", project.getName());
        params.put("Organization", Optional.ofNullable(project.getOrganization()).orElse(""));
        params.put("Members", project.getUsersQuantity());
        params.put("Launches", project.getLaunchesQuantity());
        Optional.ofNullable(project.getLastRun()).ifPresent(lastRun -> params.put("Last launch date", DateTimeFormatter.ISO_ZONED_DATE_TIME.format(ZonedDateTime.of(lastRun, ZoneOffset.UTC))));
        return params;
    }

    @Override
    public Set<ReportFormat> getAvailableReportFormats() {
        return this.availableReportFormats;
    }
}

