/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.history.param;

import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Arrays;
import java.util.Optional;

public class HistoryRequestParams {
    private int historyDepth;
    private Long parentId;
    private Long itemId;
    private Long launchId;
    private HistoryTypeEnum historyType;
    private FilterParams filterParams;

    private HistoryRequestParams(int historyDepth, Long parentId, Long itemId, Long launchId, String historyType, Long filterId, int launchesLimit, boolean isLatest) {
        this.historyDepth = historyDepth;
        this.parentId = parentId;
        this.itemId = itemId;
        this.launchId = launchId;
        Optional.ofNullable(historyType).ifPresent(type -> {
            this.historyType = HistoryTypeEnum.fromValue(historyType).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Wrong history type - '{}'", (Object[])new Object[]{historyType}).get()}));
        });
        Optional.ofNullable(filterId).ifPresent(id -> {
            this.filterParams = FilterParams.of(filterId, launchesLimit, isLatest);
        });
    }

    public int getHistoryDepth() {
        return this.historyDepth;
    }

    public Optional<FilterParams> getFilterParams() {
        return Optional.ofNullable(this.filterParams);
    }

    public Optional<Long> getParentId() {
        return Optional.ofNullable(this.parentId);
    }

    public Optional<Long> getItemId() {
        return Optional.ofNullable(this.itemId);
    }

    public Optional<Long> getLaunchId() {
        return Optional.ofNullable(this.launchId);
    }

    public Optional<HistoryTypeEnum> getHistoryType() {
        return Optional.ofNullable(this.historyType);
    }

    public static HistoryRequestParams of(int historyDepth, Long parentId, Long itemId, Long launchId, String historyType, Long filterId, int launchesLimit, boolean isLatest) {
        return new HistoryRequestParams(historyDepth, parentId, itemId, launchId, historyType, filterId, launchesLimit, isLatest);
    }

    public static final class FilterParams {
        private Long filterId;
        private int launchesLimit;
        private boolean isLatest;

        private FilterParams(Long filterId, int launchesLimit, boolean isLatest) {
            this.filterId = filterId;
            this.launchesLimit = launchesLimit;
            this.isLatest = isLatest;
        }

        public Long getFilterId() {
            return this.filterId;
        }

        public int getLaunchesLimit() {
            return this.launchesLimit;
        }

        public boolean isLatest() {
            return this.isLatest;
        }

        public static FilterParams of(Long filterId, int launchesLimit, boolean isLatest) {
            return new FilterParams(filterId, launchesLimit, isLatest);
        }
    }

    public static enum HistoryTypeEnum {
        TABLE,
        LINE,
        COMPARING;


        public static Optional<HistoryTypeEnum> fromValue(String type) {
            return Arrays.stream(HistoryTypeEnum.values()).filter(v -> v.name().equalsIgnoreCase(type)).findFirst();
        }
    }
}

