/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.history;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.history.TestItemsHistoryHandler;
import com.epam.ta.reportportal.core.item.impl.history.param.HistoryRequestParams;
import com.epam.ta.reportportal.core.item.impl.history.provider.HistoryProviderFactory;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.history.TestItemHistory;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdater;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdaterProvider;
import com.epam.ta.reportportal.ws.converter.utils.item.content.TestItemUpdaterContent;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.TestItemHistoryElement;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.stereotype.Service;

@Service
public class TestItemsHistoryHandlerImpl
implements TestItemsHistoryHandler {
    @Value(value="${rp.environment.variable.history.old}")
    private boolean oldHistory;
    private final TestItemRepository testItemRepository;
    private final HistoryProviderFactory historyProviderFactory;
    private final List<ResourceUpdaterProvider<TestItemUpdaterContent, TestItemResource>> resourceUpdaterProviders;

    @Autowired
    public TestItemsHistoryHandlerImpl(TestItemRepository testItemRepository, HistoryProviderFactory historyProviderFactory, List<ResourceUpdaterProvider<TestItemUpdaterContent, TestItemResource>> resourceUpdaterProviders) {
        this.testItemRepository = testItemRepository;
        this.historyProviderFactory = historyProviderFactory;
        this.resourceUpdaterProviders = resourceUpdaterProviders;
    }

    @Override
    public Iterable<TestItemHistoryElement> getItemsHistory(ReportPortalUser.ProjectDetails projectDetails, Queryable filter, Pageable pageable, HistoryRequestParams historyRequestParams, ReportPortalUser user) {
        this.validateHistoryDepth(historyRequestParams.getHistoryDepth());
        this.validateProjectRole(projectDetails, user);
        CompositeFilter itemHistoryFilter = new CompositeFilter(Operator.AND, new Queryable[]{filter, Filter.builder().withTarget(filter.getTarget().getClazz()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("mode", LaunchModeEnum.DEFAULT.name()).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("hasStats", String.valueOf(Boolean.TRUE)).build()).build()});
        Page<TestItemHistory> testItemHistoryPage = this.historyProviderFactory.getProvider(historyRequestParams).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find suitable history baseline provider"})).provide((Queryable)itemHistoryFilter, pageable, historyRequestParams, projectDetails, user, !this.oldHistory);
        return this.buildHistoryElements(this.oldHistory ? TestItemResource::getUniqueId : testItemResource -> String.valueOf(testItemResource.getTestCaseHash()), testItemHistoryPage, projectDetails.getProjectId(), pageable);
    }

    private void validateHistoryDepth(int historyDepth) {
        Predicate<Integer> greaterThan = t -> t > 0;
        Predicate<Integer> lessThan = t -> t < 31;
        String historyDepthMessage = (String)Suppliers.formattedSupplier((String)"Items history depth should be greater than '{}' and lower than '{}'", (Object[])new Object[]{0, 31}).get();
        BusinessRule.expect((Object)historyDepth, greaterThan.and(lessThan)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{historyDepthMessage});
    }

    private void validateProjectRole(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)(projectDetails.getProjectRole() == ProjectRole.OPERATOR ? 1 : 0), Predicate.isEqual(false)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }

    private Iterable<TestItemHistoryElement> buildHistoryElements(Function<TestItemResource, String> groupingFunction, Page<TestItemHistory> testItemHistoryPage, Long projectId, Pageable pageable) {
        List testItems = this.testItemRepository.findAllById((Iterable)testItemHistoryPage.getContent().stream().flatMap(history -> history.getItemIds().stream()).collect(Collectors.toList()));
        List<ResourceUpdater<TestItemResource>> resourceUpdaters = this.getResourceUpdaters(projectId, testItems);
        Map<String, Map<Long, TestItemResource>> itemsMapping = testItems.stream().map(item -> {
            TestItemResource testItemResource = TestItemConverter.TO_RESOURCE.apply((TestItem)item);
            resourceUpdaters.forEach(updater -> updater.updateResource(testItemResource));
            return testItemResource;
        }).collect(Collectors.groupingBy(groupingFunction, Collectors.toMap(TestItemResource::getItemId, res -> res)));
        List testItemHistoryElements = testItemHistoryPage.getContent().stream().map(history -> Optional.ofNullable((Map)itemsMapping.get(history.getGroupingField())).map(mapping -> {
            TestItemHistoryElement historyResource = new TestItemHistoryElement();
            historyResource.setGroupingField(history.getGroupingField());
            ArrayList resources = Lists.newArrayList();
            Optional.ofNullable(history.getItemIds()).ifPresent(itemIds -> itemIds.forEach(itemId -> Optional.ofNullable((TestItemResource)mapping.get(itemId)).ifPresent(resources::add)));
            historyResource.setResources((List)resources);
            return historyResource;
        })).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return (Iterable)PagedResourcesAssembler.pageConverter().apply(PageableExecutionUtils.getPage(testItemHistoryElements, (Pageable)pageable, () -> testItemHistoryPage.getTotalElements()));
    }

    private List<ResourceUpdater<TestItemResource>> getResourceUpdaters(Long projectId, List<TestItem> testItems) {
        return this.resourceUpdaterProviders.stream().map(retriever -> retriever.retrieve(TestItemUpdaterContent.of(projectId, testItems))).collect(Collectors.toList());
    }
}

