/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.function.Predicate;
import org.springframework.stereotype.Service;

@Service
public class LaunchAccessValidatorImpl
implements LaunchAccessValidator {
    private final LaunchRepository launchRepository;

    public LaunchAccessValidatorImpl(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    @Override
    public void validate(Long launchId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Specified launch with id '{}' not referenced to specified project with id '{}'", (Object[])new Object[]{launch.getId(), projectDetails.getProjectId()})});
            BusinessRule.expect((Object)(projectDetails.getProjectRole() == ProjectRole.OPERATOR && launch.getMode() == LaunchModeEnum.DEBUG ? 1 : 0), Predicate.isEqual(false)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }
}

