/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.impl;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.integration.plugin.UpdatePluginHandler;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.enums.ReservedIntegrationTypeEnum;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.integration.UpdatePluginStateRQ;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdatePluginHandlerImpl
implements UpdatePluginHandler {
    private final Pf4jPluginBox pluginBox;
    private final IntegrationTypeRepository integrationTypeRepository;

    @Autowired
    public UpdatePluginHandlerImpl(Pf4jPluginBox pluginBox, IntegrationTypeRepository integrationTypeRepository) {
        this.pluginBox = pluginBox;
        this.integrationTypeRepository = integrationTypeRepository;
    }

    @Override
    public OperationCompletionRS updatePluginState(Long id, UpdatePluginStateRQ updatePluginStateRQ) {
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findById((Object)id).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Integration type with id - '{}' not found.", (Object[])new Object[]{id}).get()}));
        boolean isEnabled = updatePluginStateRQ.getEnabled();
        integrationType.setEnabled(isEnabled);
        return this.handlePluginState(integrationType, isEnabled);
    }

    private OperationCompletionRS handlePluginState(IntegrationType integrationType, boolean isEnabled) {
        if (ReservedIntegrationTypeEnum.fromName((String)integrationType.getName()).isPresent()) {
            return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Enabled state of the plugin with id = '{}' has been switched to - '{}'", (Object[])new Object[]{integrationType.getName(), isEnabled}).get());
        }
        if (isEnabled) {
            this.loadPlugin(integrationType);
        } else {
            this.unloadPlugin(integrationType);
        }
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Enabled state of the plugin with id = '{}' has been switched to - '{}'", (Object[])new Object[]{integrationType.getName(), isEnabled}).get());
    }

    private void loadPlugin(IntegrationType integrationType) {
        if (this.pluginBox.getPluginById(integrationType.getName()).isEmpty()) {
            boolean isLoaded = this.pluginBox.loadPlugin(integrationType.getName(), integrationType.getDetails());
            BusinessRule.expect((Object)isLoaded, BooleanUtils::isTrue).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Error during loading the plugin with id = '{}'", (Object[])new Object[]{integrationType.getName()}).get()});
        }
    }

    private void unloadPlugin(IntegrationType integrationType) {
        this.pluginBox.getPluginById(integrationType.getName()).ifPresent(plugin -> {
            if (!this.pluginBox.unloadPlugin(integrationType)) {
                throw new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Error during unloading the plugin with id = '{}'", (Object[])new Object[]{integrationType.getName()}).get()});
            }
        });
    }
}

