/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.migration;

import com.epam.ta.reportportal.core.integration.migration.AbstractSecretMigrationService;
import com.epam.ta.reportportal.core.integration.util.property.SauceLabsProperties;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SaucelabsSecretMigrationService
extends AbstractSecretMigrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaucelabsSecretMigrationService.class);
    private static final String SAUCELABS_INTEGRATION_TYPE_NAME = "saucelabs";

    @Autowired
    public SaucelabsSecretMigrationService(IntegrationRepository integrationRepository, BasicTextEncryptor encryptor) {
        super(integrationRepository, encryptor);
    }

    @Override
    @Transactional
    public void migrate() {
        LOGGER.debug("Migration of saucelabs secrets has been started");
        this.integrationRepository.findAllByTypeIn(new String[]{SAUCELABS_INTEGRATION_TYPE_NAME}).forEach(it -> SaucelabsSecretMigrationService.extractParams(it).flatMap(SauceLabsProperties.ACCESS_TOKEN::getParameter).ifPresent(key -> SauceLabsProperties.ACCESS_TOKEN.setParameter(it.getParams(), this.encryptor.encrypt(key))));
        LOGGER.debug("Migration of saucelabs secrets has been finished");
    }
}

