/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.migration;

import com.epam.ta.reportportal.core.integration.migration.AbstractSecretMigrationService;
import com.epam.ta.reportportal.core.integration.util.property.BtsProperties;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
public class JiraEmailSecretMigrationService
extends AbstractSecretMigrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraEmailSecretMigrationService.class);
    private static final String JIRA_INTEGRATION_TYPE_NAME = "jira";
    private static final String EMAIL_INTEGRATION_TYPE_NAME = "email";

    @Autowired
    public JiraEmailSecretMigrationService(IntegrationRepository integrationRepository, BasicTextEncryptor encryptor) {
        super(integrationRepository, encryptor);
    }

    @Override
    @Transactional
    public void migrate() {
        LOGGER.debug("Migration of jira and email secrets has been started");
        BasicTextEncryptor staticSaltEncryptor = new BasicTextEncryptor();
        staticSaltEncryptor.setPassword("reportportal");
        this.integrationRepository.findAllByTypeIn(new String[]{JIRA_INTEGRATION_TYPE_NAME, EMAIL_INTEGRATION_TYPE_NAME}).forEach(it -> JiraEmailSecretMigrationService.extractParams(it).flatMap(BtsProperties.PASSWORD::getParam).filter(pass -> !StringUtils.isEmpty((Object)pass)).ifPresent(pass -> BtsProperties.PASSWORD.setParam(it.getParams(), this.encryptor.encrypt(staticSaltEncryptor.decrypt(pass)))));
        LOGGER.debug("Migration of jira and email secrets has been finished");
    }
}

