/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl.junit;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.imprt.impl.DateUtils;
import com.epam.ta.reportportal.core.imprt.impl.junit.XunitReportTag;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.log.CreateLogHandler;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.base.Strings;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

@Component
@Scope(value="prototype")
public class XunitImportHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XunitImportHandler.class);
    private final StartTestItemHandler startTestItemHandler;
    private final FinishTestItemHandler finishTestItemHandler;
    private final CreateLogHandler createLogHandler;
    private ReportPortalUser.ProjectDetails projectDetails;
    private ReportPortalUser user;
    private String launchUuid;
    private String currentItemUuid;
    private LocalDateTime startSuiteTime;
    private long commonDuration;
    private long currentDuration;
    private Deque<String> itemUuids;
    private StatusEnum status;
    private StringBuilder message;
    private LocalDateTime startItemTime;

    @Autowired
    public XunitImportHandler(StartTestItemHandler startTestItemHandler, FinishTestItemHandler finishTestItemHandler, CreateLogHandler createLogHandler) {
        this.startTestItemHandler = startTestItemHandler;
        this.finishTestItemHandler = finishTestItemHandler;
        this.createLogHandler = createLogHandler;
    }

    @Override
    public void startDocument() {
        this.itemUuids = new ArrayDeque<String>();
        this.message = new StringBuilder();
        this.startSuiteTime = LocalDateTime.now();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (XunitReportTag.fromString(qName)) {
            case TESTSUITE: {
                if (this.itemUuids.isEmpty()) {
                    this.startRootItem(attributes.getValue(XunitReportTag.ATTR_NAME.getValue()), attributes.getValue(XunitReportTag.TIMESTAMP.getValue()));
                    break;
                }
                this.startTestItem(attributes.getValue(XunitReportTag.ATTR_NAME.getValue()));
                break;
            }
            case TESTCASE: {
                this.startStepItem(attributes.getValue(XunitReportTag.ATTR_NAME.getValue()), attributes.getValue(XunitReportTag.ATTR_TIME.getValue()));
                break;
            }
            case ERROR: 
            case FAILURE: {
                this.message = new StringBuilder();
                this.status = StatusEnum.FAILED;
                break;
            }
            case SKIPPED: {
                this.message = new StringBuilder();
                this.status = StatusEnum.SKIPPED;
                break;
            }
            case SYSTEM_OUT: 
            case SYSTEM_ERR: 
            case WARNING: {
                this.message = new StringBuilder();
                break;
            }
            default: {
                LOGGER.warn("Unknown tag: {}", (Object)qName);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (XunitReportTag.fromString(qName)) {
            case TESTSUITE: {
                this.finishRootItem();
                break;
            }
            case TESTCASE: {
                this.finishTestItem();
                break;
            }
            case ERROR: 
            case FAILURE: 
            case SKIPPED: 
            case SYSTEM_ERR: {
                this.attachLog(LogLevel.ERROR);
                break;
            }
            case SYSTEM_OUT: {
                this.attachLog(LogLevel.INFO);
                break;
            }
            case WARNING: {
                this.attachLog(LogLevel.WARN);
                break;
            }
            default: {
                LOGGER.warn("Unknown tag: {}", (Object)qName);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String msg = new String(ch, start, length);
        if (!msg.isEmpty()) {
            this.message.append(msg);
        }
    }

    private void startRootItem(String name, String timestamp) {
        if (null != timestamp) {
            this.startItemTime = this.parseTimeStamp(timestamp);
            if (this.startSuiteTime.isAfter(this.startItemTime)) {
                this.startSuiteTime = LocalDateTime.of(this.startItemTime.toLocalDate(), this.startItemTime.toLocalTime());
            }
        } else {
            this.startItemTime = LocalDateTime.now();
        }
        StartTestItemRQ rq = this.buildStartTestRq(name);
        String id = this.startTestItemHandler.startRootItem(this.user, this.projectDetails, rq).getId();
        this.itemUuids.push(id);
    }

    private LocalDateTime parseTimeStamp(String timestamp) {
        LocalDateTime localDateTime = null;
        try {
            localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(timestamp)), ZoneId.systemDefault());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (null == localDateTime) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.RFC_1123_DATE_TIME).appendOptional(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendZoneId().optionalEnd().toFormatter();
            localDateTime = LocalDateTime.parse(timestamp, formatter);
        }
        return localDateTime;
    }

    private void startTestItem(String name) {
        StartTestItemRQ rq = this.buildStartTestRq(name);
        String id = this.startTestItemHandler.startChildItem(this.user, this.projectDetails, rq, this.itemUuids.peek()).getId();
        this.itemUuids.push(id);
    }

    private void startStepItem(String name, String duration) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setLaunchUuid(this.launchUuid);
        rq.setStartTime((Date)EntityUtils.TO_DATE.apply(this.startItemTime));
        rq.setType(TestItemTypeEnum.STEP.name());
        rq.setName(name);
        String id = this.startTestItemHandler.startChildItem(this.user, this.projectDetails, rq, this.itemUuids.peek()).getId();
        this.currentDuration = DateUtils.toMillis(duration);
        this.currentItemUuid = id;
        this.itemUuids.push(id);
    }

    private void finishRootItem() {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime((Date)EntityUtils.TO_DATE.apply(this.startItemTime));
        this.finishTestItemHandler.finishTestItem(this.user, this.projectDetails, this.itemUuids.poll(), rq);
        this.status = null;
    }

    private void finishTestItem() {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        this.startItemTime = this.startItemTime.plus(this.currentDuration, ChronoUnit.MILLIS);
        this.commonDuration += this.currentDuration;
        rq.setEndTime((Date)EntityUtils.TO_DATE.apply(this.startItemTime));
        rq.setStatus(Optional.ofNullable(this.status).orElse(StatusEnum.PASSED).name());
        this.currentItemUuid = this.itemUuids.poll();
        this.finishTestItemHandler.finishTestItem(this.user, this.projectDetails, this.currentItemUuid, rq);
        this.status = null;
    }

    private void attachLog(LogLevel logLevel) {
        if (null != this.message && this.message.length() != 0) {
            SaveLogRQ saveLogRQ = new SaveLogRQ();
            saveLogRQ.setLevel(logLevel.name());
            saveLogRQ.setLogTime((Date)EntityUtils.TO_DATE.apply(this.startItemTime));
            saveLogRQ.setMessage(this.message.toString().trim());
            saveLogRQ.setItemUuid(this.currentItemUuid);
            this.createLogHandler.createLog(saveLogRQ, null, this.projectDetails);
        }
    }

    XunitImportHandler withParameters(ReportPortalUser.ProjectDetails projectDetails, String launchId, ReportPortalUser user) {
        this.projectDetails = projectDetails;
        this.launchUuid = launchId;
        this.user = user;
        return this;
    }

    private StartTestItemRQ buildStartTestRq(String name) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setLaunchUuid(this.launchUuid);
        rq.setStartTime((Date)EntityUtils.TO_DATE.apply(this.startItemTime));
        rq.setType(TestItemTypeEnum.TEST.name());
        rq.setName(Strings.isNullOrEmpty((String)name) ? "no_name" : name);
        return rq;
    }

    LocalDateTime getStartSuiteTime() {
        return this.startSuiteTime;
    }

    long getCommonDuration() {
        return this.commonDuration;
    }
}

