/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.imprt.impl.AbstractImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.ParseResults;
import com.epam.ta.reportportal.core.imprt.impl.junit.XunitParseJob;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XmlImportStrategy
extends AbstractImportStrategy {
    @Autowired
    private Provider<XunitParseJob> xmlParseJobProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String importLaunch(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, File file, String baseUrl) {
        try {
            String string = this.processXmlFile(file, projectDetails, user, baseUrl);
            return string;
        }
        finally {
            try {
                Optional.ofNullable(file).ifPresent(File::delete);
            }
            catch (Exception e) {
                LOGGER.error("File '{}' was not successfully deleted.", (Object)file.getName(), (Object)e);
            }
        }
    }

    private String processXmlFile(File xml, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, String baseUrl) {
        String string;
        String savedLaunchId = null;
        FileInputStream xmlStream = new FileInputStream(xml);
        try {
            String launchId;
            savedLaunchId = launchId = this.startLaunch(projectDetails, user, xml.getName().substring(0, xml.getName().indexOf(".xml")));
            XunitParseJob job = ((XunitParseJob)this.xmlParseJobProvider.get()).withParameters(projectDetails, launchId, user, xmlStream);
            ParseResults parseResults = job.call();
            this.finishLaunch(launchId, projectDetails, user, parseResults, baseUrl);
            string = launchId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)xmlStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.updateBrokenLaunch(savedLaunchId);
                throw new ReportPortalException(ErrorType.IMPORT_FILE_ERROR, new Object[]{this.cleanMessage(e)});
            }
        }
        ((InputStream)xmlStream).close();
        return string;
    }
}

