/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.ImportFinishedEvent;
import com.epam.ta.reportportal.core.events.activity.ImportStartedEvent;
import com.epam.ta.reportportal.core.imprt.ImportLaunchHandler;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategyFactory;
import com.epam.ta.reportportal.core.imprt.impl.ImportType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportLaunchHandlerImpl
implements ImportLaunchHandler {
    private ImportStrategyFactory importStrategyFactory;
    private MessageBus messageBus;

    @Autowired
    public ImportLaunchHandlerImpl(ImportStrategyFactory importStrategyFactory, MessageBus messageBus) {
        this.importStrategyFactory = importStrategyFactory;
        this.messageBus = messageBus;
    }

    @Override
    public OperationCompletionRS importLaunch(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, String format, MultipartFile file, String baseUrl) {
        this.validate(file);
        ImportType type = ImportType.fromValue(format).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unknown import type - " + format}));
        File tempFile = this.transferToTempFile(file);
        this.messageBus.publishActivity(new ImportStartedEvent(user.getUserId(), user.getUsername(), projectDetails.getProjectId(), file.getOriginalFilename()));
        ImportStrategy strategy = this.importStrategyFactory.getImportStrategy(type, file.getOriginalFilename());
        String launchId = strategy.importLaunch(projectDetails, user, tempFile, baseUrl);
        this.messageBus.publishActivity(new ImportFinishedEvent(user.getUserId(), user.getUsername(), projectDetails.getProjectId(), file.getOriginalFilename()));
        return new OperationCompletionRS("Launch with id = " + launchId + " is successfully imported.");
    }

    private void validate(MultipartFile file) {
        BusinessRule.expect((Object)file.getOriginalFilename(), (Predicate)Predicates.notNull()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"File name should be not empty."});
        BusinessRule.expect((Object)file.getOriginalFilename(), it -> it.endsWith("zip") || it.endsWith("xml")).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Should be a zip archive or an xml file " + file.getOriginalFilename()});
    }

    private File transferToTempFile(MultipartFile file) {
        try {
            File tmp = File.createTempFile(file.getOriginalFilename(), "." + FilenameUtils.getExtension((String)file.getOriginalFilename()));
            file.transferTo(tmp);
            return tmp;
        }
        catch (IOException e) {
            throw new ReportPortalException("Error during transferring multipart file.", (Throwable)e);
        }
    }
}

