/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.filter.GetUserFilterHandler;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.filter.UserFilterResource;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GetUserFilterHandlerImpl
implements GetUserFilterHandler {
    private UserFilterRepository filterRepository;

    @Autowired
    public void setFilterRepository(UserFilterRepository filterRepository) {
        this.filterRepository = filterRepository;
    }

    @Override
    public Iterable<UserFilterResource> getPermitted(String projectName, Pageable pageable, Filter filter, ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = ProjectExtractor.extractProjectDetails(user, projectName);
        Page permitted = this.filterRepository.getPermitted(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter(UserFilterConverter.TO_FILTER_RESOURCE).apply((Page<UserFilter>)permitted);
    }

    @Override
    public Iterable<UserFilterResource> getOwn(String projectName, Pageable pageable, Filter filter, ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = ProjectExtractor.extractProjectDetails(user, projectName);
        Page filters = this.filterRepository.getOwn(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter(UserFilterConverter.TO_FILTER_RESOURCE).apply((Page<UserFilter>)filters);
    }

    @Override
    public Iterable<UserFilterResource> getShared(String projectName, Pageable pageable, Filter filter, ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = ProjectExtractor.extractProjectDetails(user, projectName);
        Page filters = this.filterRepository.getShared(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter(UserFilterConverter.TO_FILTER_RESOURCE).apply((Page<UserFilter>)filters);
    }

    @Override
    public Iterable<SharedEntity> getFiltersNames(ReportPortalUser.ProjectDetails projectDetails, Pageable pageable, Filter filter, ReportPortalUser user, boolean isShared) {
        Page filters = isShared ? this.filterRepository.getShared(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername()) : this.filterRepository.getOwn(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter(UserFilterConverter.TO_SHARED_ENTITY).apply((Page<UserFilter>)filters);
    }

    @Override
    @PostFilter(value="hasPermission(filterObject, 'aclReadPermission') || hasPermission(filterObject, 'aclFullPermission') || hasRole('ADMINISTRATOR')")
    public List<UserFilter> getFiltersById(Long[] ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        return this.filterRepository.findAllByIdInAndProjectId((Collection)Lists.newArrayList((Object[])ids), projectDetails.getProjectId());
    }
}

