/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.subscriber.impl;

import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.pattern.PatternAnalyzer;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.subscriber.LaunchFinishedEventSubscriber;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchPatternAnalysisSubscriber
implements LaunchFinishedEventSubscriber {
    private final PatternAnalyzer patternAnalyzer;

    @Autowired
    public LaunchPatternAnalysisSubscriber(PatternAnalyzer patternAnalyzer) {
        this.patternAnalyzer = patternAnalyzer;
    }

    @Override
    public void handleEvent(LaunchFinishedEvent launchFinishedEvent, Project project, Launch launch) {
        boolean isPatternAnalysisEnabled = BooleanUtils.toBoolean((String)((String)ProjectUtils.getConfigParameters((Set)project.getProjectAttributes()).get(ProjectAttributeEnum.AUTO_PATTERN_ANALYZER_ENABLED.getAttribute())));
        if (isPatternAnalysisEnabled) {
            this.patternAnalyzer.analyzeTestItems(launch, Collections.singleton(AnalyzeItemsMode.TO_INVESTIGATE));
        }
    }

    public int getOrder() {
        return 3;
    }
}

