/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler;

import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.subscriber.LaunchFinishedEventSubscriber;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class LaunchFinishedEventHandler {
    private final ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;
    private final List<LaunchFinishedEventSubscriber> launchFinishedEventSubscribers;

    @Autowired
    public LaunchFinishedEventHandler(ProjectRepository projectRepository, LaunchRepository launchRepository, List<LaunchFinishedEventSubscriber> launchFinishedEventSubscribers) {
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
        this.launchFinishedEventSubscribers = launchFinishedEventSubscribers.stream().sorted(Comparator.comparingInt(Ordered::getOrder)).collect(Collectors.toList());
    }

    @Async
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @TransactionalEventListener
    public void onApplicationEvent(LaunchFinishedEvent event) {
        Launch launch = (Launch)this.launchRepository.findById((Object)event.getLaunchActivityResource().getId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{event.getLaunchActivityResource().getId()}));
        if (LaunchModeEnum.DEBUG == launch.getMode()) {
            return;
        }
        Project project = (Project)this.projectRepository.findById((Object)launch.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{launch.getProjectId()}));
        this.launchFinishedEventSubscribers.forEach(subscriber -> subscriber.handleEvent(event, project, launch));
    }
}

