/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AroundEvent;
import com.epam.ta.reportportal.core.events.activity.util.ActivityDetailsUtil;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.HistoryField;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.activity.WidgetActivityResource;
import java.util.Optional;
import java.util.Set;

public class WidgetUpdatedEvent
extends AroundEvent<WidgetActivityResource>
implements ActivityEvent {
    private String widgetOptionsBefore;
    private String widgetOptionsAfter;

    public WidgetUpdatedEvent() {
    }

    public WidgetUpdatedEvent(WidgetActivityResource before, WidgetActivityResource after, String widgetOptionsBefore, String widgetOptionsAfter, Long userId, String userLogin) {
        super(userId, userLogin, before, after);
        this.widgetOptionsBefore = widgetOptionsBefore;
        this.widgetOptionsAfter = widgetOptionsAfter;
    }

    public String getWidgetOptionsBefore() {
        return this.widgetOptionsBefore;
    }

    public void setWidgetOptionsBefore(String widgetOptionsBefore) {
        this.widgetOptionsBefore = widgetOptionsBefore;
    }

    public String getWidgetOptionsAfter() {
        return this.widgetOptionsAfter;
    }

    public void setWidgetOptionsAfter(String widgetOptionsAfter) {
        this.widgetOptionsAfter = widgetOptionsAfter;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(ActivityAction.UPDATE_WIDGET).addActivityEntityType(Activity.ActivityEntityType.WIDGET).addUserId(this.getUserId()).addUserName(this.getUserLogin()).addObjectId(((WidgetActivityResource)this.getAfter()).getId()).addObjectName(((WidgetActivityResource)this.getAfter()).getName()).addProjectId(((WidgetActivityResource)this.getAfter()).getProjectId()).addHistoryField(ActivityDetailsUtil.processBoolean("share", ((WidgetActivityResource)this.getBefore()).isShared(), ((WidgetActivityResource)this.getAfter()).isShared())).addHistoryField(ActivityDetailsUtil.processName(((WidgetActivityResource)this.getBefore()).getName(), ((WidgetActivityResource)this.getAfter()).getName())).addHistoryField(ActivityDetailsUtil.processDescription(((WidgetActivityResource)this.getBefore()).getDescription(), ((WidgetActivityResource)this.getAfter()).getDescription())).addHistoryField(this.processItemsCount(((WidgetActivityResource)this.getBefore()).getItemsCount(), ((WidgetActivityResource)this.getAfter()).getItemsCount())).addHistoryField(this.processFields(((WidgetActivityResource)this.getBefore()).getContentFields(), ((WidgetActivityResource)this.getAfter()).getContentFields())).addHistoryField(Optional.of(HistoryField.of((String)"widgetOptions", (String)this.widgetOptionsBefore, (String)this.widgetOptionsAfter))).get();
    }

    private Optional<HistoryField> processItemsCount(int before, int after) {
        if (before != after) {
            return Optional.of(HistoryField.of((String)"itemsCount", (String)String.valueOf(before), (String)String.valueOf(after)));
        }
        return Optional.empty();
    }

    private Optional<HistoryField> processFields(Set<String> before, Set<String> after) {
        if (before != null && after != null && !before.equals(after)) {
            String oldValue = String.join((CharSequence)", ", before);
            String newValue = String.join((CharSequence)", ", after);
            return Optional.of(HistoryField.of((String)"contentFields", (String)oldValue, (String)newValue));
        }
        return Optional.empty();
    }
}

