/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.BeforeEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.ActivityDetails;
import com.epam.ta.reportportal.entity.activity.HistoryField;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import com.epam.ta.reportportal.ws.model.project.email.ProjectNotificationConfigDTO;
import com.epam.ta.reportportal.ws.model.project.email.SenderCaseDTO;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NotificationsConfigUpdatedEvent
extends BeforeEvent<ProjectResource>
implements ActivityEvent {
    private ProjectNotificationConfigDTO updateProjectNotificationConfigRQ;

    public NotificationsConfigUpdatedEvent() {
    }

    public NotificationsConfigUpdatedEvent(ProjectResource before, ProjectNotificationConfigDTO updateProjectNotificationConfigRQ, Long userId, String userLogin) {
        super(userId, userLogin, before);
        this.updateProjectNotificationConfigRQ = updateProjectNotificationConfigRQ;
    }

    public ProjectNotificationConfigDTO getUpdateProjectNotificationConfigRQ() {
        return this.updateProjectNotificationConfigRQ;
    }

    public void setUpdateProjectNotificationConfigRQ(ProjectNotificationConfigDTO updateProjectNotificationConfigRQ) {
        this.updateProjectNotificationConfigRQ = updateProjectNotificationConfigRQ;
    }

    @Override
    public Activity toActivity() {
        ActivityDetails details = new ActivityDetails(((ProjectResource)this.getBefore()).getProjectName());
        this.processEmailConfiguration(details, (ProjectResource)this.getBefore(), this.updateProjectNotificationConfigRQ);
        return new ActivityBuilder().addCreatedNow().addAction(ActivityAction.UPDATE_PROJECT).addActivityEntityType(Activity.ActivityEntityType.EMAIL_CONFIG).addProjectId(((ProjectResource)this.getBefore()).getProjectId()).addUserId(this.getUserId()).addUserName(this.getUserLogin()).addObjectId(((ProjectResource)this.getBefore()).getProjectId()).addDetails(details).get();
    }

    private void processEmailConfiguration(ActivityDetails details, ProjectResource project, ProjectNotificationConfigDTO updateProjectNotificationConfigRQ) {
        Optional.ofNullable(project.getConfiguration().getProjectConfig()).ifPresent(cfg -> {
            boolean isEmailCasesChanged;
            List before = Optional.ofNullable(cfg.getSenderCases()).orElseGet(Collections::emptyList);
            boolean bl = isEmailCasesChanged = !before.equals(updateProjectNotificationConfigRQ.getSenderCases());
            if (!isEmailCasesChanged) {
                details.addHistoryField(HistoryField.of((String)"emailCases", (String)"", (String)""));
            } else {
                details.addHistoryField(HistoryField.of((String)"emailCases", (String)before.stream().map(SenderCaseDTO::toString).collect(Collectors.joining(", ")), (String)updateProjectNotificationConfigRQ.getSenderCases().stream().map(SenderCaseDTO::toString).collect(Collectors.joining(", "))));
            }
        });
    }
}

