/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.rabbit;

import com.epam.ta.reportportal.core.analyzer.auto.client.RabbitMqManagementClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.impl.RabbitMqManagementClientTemplate;
import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.rabbitmq.http.client.Client;
import java.net.URI;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={Conditions.NotTestCondition.class})
public class AnalyzerRabbitMqConfiguration {
    @Autowired
    private MessageConverter messageConverter;

    @Bean
    public RabbitMqManagementClient managementTemplate(@Value(value="${rp.amqp.api-address}") String address) {
        Client rabbitClient;
        try {
            rabbitClient = new Client(address);
        }
        catch (Exception e) {
            throw new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[]{"Cannot create a HTTP rabbit client instance. Incorrect api address " + address});
        }
        return new RabbitMqManagementClientTemplate(rabbitClient);
    }

    @Bean(name={"analyzerConnectionFactory"})
    public ConnectionFactory analyzerConnectionFactory(@Value(value="${rp.amqp.addresses}") URI addresses) {
        CachingConnectionFactory factory = new CachingConnectionFactory(addresses);
        factory.setVirtualHost("analyzer");
        return factory;
    }

    @Bean(name={"analyzerRabbitTemplate"})
    public RabbitTemplate analyzerRabbitTemplate(@Autowired @Qualifier(value="analyzerConnectionFactory") ConnectionFactory connectionFactory, @Value(value="${rp.amqp.reply-timeout}") long replyTimeout) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter(this.messageConverter);
        rabbitTemplate.setReplyTimeout(replyTimeout);
        return rabbitTemplate;
    }
}

