/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CriteriaHolder;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterTarget;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.paths.RelativePathProvider;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@Conditional(value={Conditions.NotTestCondition.class})
@EnableSwagger2
@ComponentScan(basePackages={"com.epam.ta.reportportal.ws.controller"})
public class Swagger2Configuration {
    private static final Set<String> hiddenParams = ImmutableSet.builder().add((Object)"attributeName").build();
    @Autowired
    private ServletContext servletContext;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${info.build.version}")
    private String buildVersion;

    @Bean
    public Docket docket() {
        ApiInfo rpInfo = new ApiInfo("Report Portal", "Report Portal API documentation", this.buildVersion, null, new Contact("Support", null, "Support EPMC-TST Report Portal <SupportEPMC-TSTReportPortal@epam.com>"), "Apache 2.0", "http://www.apache.org/licenses/LICENSE-2.0", Collections.emptyList());
        Docket rpDocket = new Docket(DocumentationType.SWAGGER_2).ignoredParameterTypes(new Class[]{ReportPortalUser.class, Filter.class, Queryable.class, Pageable.class, UserRole.class}).pathProvider(this.rpPathProvider()).useDefaultResponseMessages(false).select().apis(Predicates.not((Predicate)Predicates.or((Predicate)RequestHandlerSelectors.basePackage((String)"org.springframework.boot"), (Predicate)RequestHandlerSelectors.basePackage((String)"org.springframework.cloud")))).build();
        rpDocket.apiInfo(rpInfo);
        return rpDocket;
    }

    @Bean
    public PathProvider rpPathProvider() {
        return new RelativePathProvider(this.servletContext){

            public String getApplicationBasePath() {
                return "/" + Swagger2Configuration.this.applicationName + super.getApplicationBasePath();
            }
        };
    }

    @Bean
    OperationPageableParameterReader pageableParameterBuilderPlugin(TypeNameExtractor nameExtractor, TypeResolver resolver) {
        return new OperationPageableParameterReader(nameExtractor, resolver);
    }

    @Bean
    public UiConfiguration uiConfig() {
        return UiConfigurationBuilder.builder().build();
    }

    private static class RPPathProvider
    extends RelativePathProvider {
        private String gatewayPath;

        RPPathProvider(ServletContext servletContext, String gatewayPath) {
            super(servletContext);
            this.gatewayPath = gatewayPath;
        }

        protected String applicationPath() {
            return "/" + this.gatewayPath + super.applicationPath();
        }
    }

    @Component
    public class OperationPageableParameterReader
    implements OperationBuilderPlugin {
        private final TypeNameExtractor nameExtractor;
        private final TypeResolver resolver;
        private final ResolvedType pageableType;
        private final ResolvedType filterType;

        @Autowired
        public OperationPageableParameterReader(TypeNameExtractor nameExtractor, TypeResolver resolver) {
            this.nameExtractor = nameExtractor;
            this.resolver = resolver;
            this.pageableType = resolver.resolve(Pageable.class, new Type[0]);
            this.filterType = resolver.resolve(Filter.class, new Type[0]);
        }

        public void apply(OperationContext context) {
            List methodParameters = context.getParameters();
            ArrayList parameters = Lists.newArrayList();
            for (ResolvedMethodParameter methodParameter : methodParameters) {
                ResolvedType resolvedType = methodParameter.getParameterType();
                ParameterContext parameterContext = new ParameterContext(methodParameter, new ParameterBuilder(), context.getDocumentationContext(), context.getGenericsNamingStrategy(), context);
                Function<ResolvedType, ? extends ModelReference> factory = this.createModelRefFactory(parameterContext);
                ModelReference stringModel = factory.apply(this.resolver.resolve(List.class, new Type[]{String.class}));
                if (this.pageableType.equals((Object)resolvedType)) {
                    ModelReference intModel = factory.apply(this.resolver.resolve(Integer.TYPE, new Type[0]));
                    parameters.add(new ParameterBuilder().parameterType("query").name("page.page").modelRef(intModel).description("Results page you want to retrieve (0..N)").build());
                    parameters.add(new ParameterBuilder().parameterType("query").name("page.size").modelRef(intModel).description("Number of records per page").build());
                    parameters.add(new ParameterBuilder().parameterType("query").name("page.sort").modelRef(stringModel).allowMultiple(true).description("Sorting criteria in the format: property, (asc|desc). Default sort order is ascending. Multiple sort criteria are supported.").build());
                    context.operationBuilder().parameters((List)parameters);
                    continue;
                }
                if (!this.filterType.equals((Object)resolvedType)) continue;
                FilterFor filterClass = (FilterFor)methodParameter.findAnnotation(FilterFor.class).get();
                List<Object> defaultParams = Lists.newArrayList();
                if (filterClass.value() == TestItem.class || filterClass.value() == Launch.class) {
                    defaultParams = StatisticsHelper.defaultStatisticsFields().map(it -> this.buildParameters(parameterContext, factory, (String)it)).collect(Collectors.toList());
                }
                List criteriaList = FilterTarget.findByClass(filterClass.value()).getCriteriaHolders();
                List params = criteriaList.stream().filter(ch -> !hiddenParams.contains(ch.getFilterCriteria())).map(it -> this.buildParameters(parameterContext, factory, (CriteriaHolder)it)).filter(p -> null != p.getModelRef().getItemType() || !Character.isUpperCase(p.getModelRef().getType().toCharArray()[0])).collect(Collectors.toList());
                params.addAll(defaultParams);
                context.operationBuilder().parameters(params);
            }
        }

        private Parameter buildParameters(ParameterContext parameterContext, Function<ResolvedType, ? extends ModelReference> factory, CriteriaHolder criteriaHolder) {
            return parameterContext.parameterBuilder().parameterType("query").name("filter.eq." + criteriaHolder.getFilterCriteria()).allowMultiple(true).modelRef(factory.apply(this.resolver.resolve((Type)(criteriaHolder.getDataType() == Timestamp.class ? Date.class : criteriaHolder.getDataType()), new Type[0]))).description("Filters by '" + criteriaHolder.getFilterCriteria() + "'").build();
        }

        private Parameter buildParameters(ParameterContext parameterContext, Function<ResolvedType, ? extends ModelReference> factory, String parameter) {
            return parameterContext.parameterBuilder().parameterType("query").name("filter.eq." + parameter).allowMultiple(true).modelRef(factory.apply(this.resolver.resolve(Long.class, new Type[0]))).description("Filters by '" + parameter + "'").build();
        }

        public boolean supports(DocumentationType delimiter) {
            return true;
        }

        private Function<ResolvedType, ? extends ModelReference> createModelRefFactory(ParameterContext context) {
            ModelContext modelContext = ModelContext.inputParam((String)"default", (Type)context.resolvedMethodParameter().getParameterType().getErasedType(), (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getGenericNamingStrategy(), (ImmutableSet)context.getIgnorableParameterTypes());
            return ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.nameExtractor);
        }
    }
}

