/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.commons.ExceptionMappings;
import com.epam.ta.reportportal.commons.exception.forwarding.ClientResponseForwardingExceptionHandler;
import com.epam.ta.reportportal.commons.exception.rest.DefaultErrorResolver;
import com.epam.ta.reportportal.commons.exception.rest.ErrorResolver;
import com.epam.ta.reportportal.commons.exception.rest.ReportPortalExceptionResolver;
import com.epam.ta.reportportal.commons.exception.rest.RestExceptionHandler;
import com.epam.ta.reportportal.ws.resolver.ActiveUserWebArgumentResolver;
import com.epam.ta.reportportal.ws.resolver.FilterCriteriaResolver;
import com.epam.ta.reportportal.ws.resolver.JsonViewSupportFactoryBean;
import com.epam.ta.reportportal.ws.resolver.PagingHandlerMethodArgumentResolver;
import com.epam.ta.reportportal.ws.resolver.PredefinedFilterCriteriaResolver;
import com.epam.ta.reportportal.ws.resolver.SortArgumentResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.validation.beanvalidation.BeanValidationPostProcessor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.MultipartFilter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={MultipartConfig.class})
public class MvcConfig
implements WebMvcConfigurer {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private List<HttpMessageConverter<?>> converters;
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/public/", "classpath:/META-INF/resources/", "classpath:/resources/"};

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (!registry.hasMappingForPattern("/**")) {
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(CLASSPATH_RESOURCE_LOCATIONS);
        }
        if (!registry.hasMappingForPattern("/webjars/**")) {
            registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        }
    }

    @Bean
    public SortArgumentResolver sortArgumentResolver() {
        SortArgumentResolver argumentResolver = new SortArgumentResolver();
        argumentResolver.setSortParameter("page.sort");
        argumentResolver.setQualifierDelimiter("+");
        return argumentResolver;
    }

    @Bean
    public JsonViewSupportFactoryBean jsonViewSupportFactoryBean() {
        return new JsonViewSupportFactoryBean();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.clear();
        PagingHandlerMethodArgumentResolver pageableResolver = new PagingHandlerMethodArgumentResolver(this.sortArgumentResolver());
        pageableResolver.setPrefix("page.");
        pageableResolver.setOneIndexedParameters(true);
        argumentResolvers.add((HandlerMethodArgumentResolver)pageableResolver);
        argumentResolvers.add(new ActiveUserWebArgumentResolver());
        argumentResolvers.add(new FilterCriteriaResolver());
        argumentResolvers.add(new PredefinedFilterCriteriaResolver());
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.clear();
        converters.add((HttpMessageConverter<?>)this.jsonConverter());
        converters.add((HttpMessageConverter<?>)this.stringConverter());
    }

    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        ClientResponseForwardingExceptionHandler forwardingExceptionHandler = new ClientResponseForwardingExceptionHandler();
        forwardingExceptionHandler.setOrder(Integer.MIN_VALUE);
        exceptionResolvers.add((HandlerExceptionResolver)forwardingExceptionHandler);
        RestExceptionHandler handler = new RestExceptionHandler();
        handler.setOrder(-2147483647);
        DefaultErrorResolver defaultErrorResolver = new DefaultErrorResolver(ExceptionMappings.DEFAULT_MAPPING);
        handler.setErrorResolver((ErrorResolver)new ReportPortalExceptionResolver((ErrorResolver)defaultErrorResolver));
        handler.setMessageConverters(Collections.singletonList(this.jsonConverter()));
        exceptionResolvers.add((HandlerExceptionResolver)handler);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseSuffixPatternMatch(Boolean.valueOf(false));
    }

    @Bean
    public BeanValidationPostProcessor beanValidationPostProcessor() {
        return new BeanValidationPostProcessor();
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonConverter() {
        return new MappingJackson2HttpMessageConverter(this.objectMapper);
    }

    @Bean
    public StringHttpMessageConverter stringConverter() {
        StringHttpMessageConverter converter = new StringHttpMessageConverter();
        converter.setSupportedMediaTypes(Collections.singletonList(MediaType.TEXT_PLAIN));
        return converter;
    }

    @Bean
    HttpMessageConverters httpMessageConverters() {
        return new HttpMessageConverters(this.converters);
    }

    @Profile(value={"!unittest"})
    @Bean
    @Order(value=0)
    public MultipartFilter multipartFilter() {
        MultipartFilter multipartFilter = new MultipartFilter();
        multipartFilter.setMultipartResolverBeanName("multipartResolver");
        return multipartFilter;
    }

    @Profile(value={"!unittest"})
    @Bean(name={"multipartResolver"})
    public CommonsMultipartResolver multipartResolver(MultipartConfig multipartConfig) {
        CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver(){

            protected DiskFileItemFactory newFileItemFactory() {
                DiskFileItemFactory diskFileItemFactory = super.newFileItemFactory();
                diskFileItemFactory.setFileCleaningTracker(null);
                return diskFileItemFactory;
            }

            public void cleanupMultipart(MultipartHttpServletRequest request) {
            }
        };
        commonsMultipartResolver.setResolveLazily(true);
        commonsMultipartResolver.setMaxUploadSize(multipartConfig.maxUploadSize);
        commonsMultipartResolver.setMaxUploadSizePerFile(multipartConfig.maxFileSize);
        return commonsMultipartResolver;
    }

    @ConfigurationProperties(value="rp.upload")
    public static class MultipartConfig {
        long maxUploadSize = 0x8000000L;
        long maxFileSize = 0x8000000L;

        public void setMaxUploadSize(String maxUploadSize) {
            this.maxUploadSize = this.parseSize(maxUploadSize);
        }

        public void setMaxFileSize(String maxFileSize) {
            this.maxFileSize = this.parseSize(maxFileSize);
        }

        private long parseSize(String size) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)size) ? 1 : 0) != 0, (Object)"Size must not be empty");
            size = size.toUpperCase();
            if (size.endsWith("KB")) {
                return Long.parseLong(size.substring(0, size.length() - 2)) * 1024L;
            }
            if (size.endsWith("MB")) {
                return Long.parseLong(size.substring(0, size.length() - 2)) * 1024L * 1024L;
            }
            if (size.endsWith("GB")) {
                return Long.parseLong(size.substring(0, size.length() - 2)) * 1024L * 1024L * 1024L;
            }
            return Long.parseLong(size);
        }
    }
}

