/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.CompositeFilterCondition;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.pattern.PatternAnalyzer;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.PatternAnalysisSelector;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.condition.PatternConditionProviderChain;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.PatternMatchedEvent;
import com.epam.ta.reportportal.dao.PatternTemplateRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.entity.pattern.PatternTemplateTestItemPojo;
import com.epam.ta.reportportal.entity.pattern.PatternTemplateType;
import com.epam.ta.reportportal.ws.converter.converters.PatternTemplateConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.activity.PatternTemplateActivityResource;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class PatternAnalyzerImpl
implements PatternAnalyzer {
    public static final Logger LOGGER = LoggerFactory.getLogger(PatternAnalyzerImpl.class);
    private final PatternTemplateRepository patternTemplateRepository;
    private final PatternConditionProviderChain patternConditionProviderChain;
    private final Map<PatternTemplateType, PatternAnalysisSelector> patternAnalysisSelectorMapping;
    private final TaskExecutor patternAnalysisTaskExecutor;
    private final AnalyzerStatusCache analyzerStatusCache;
    private final MessageBus messageBus;

    @Autowired
    public PatternAnalyzerImpl(PatternTemplateRepository patternTemplateRepository, @Qualifier(value="patternAnalysisSelectorMapping") Map<PatternTemplateType, PatternAnalysisSelector> patternAnalysisSelectorMapping, TaskExecutor patternAnalysisTaskExecutor, PatternConditionProviderChain patternConditionProviderChain, AnalyzerStatusCache analyzerStatusCache, MessageBus messageBus) {
        this.patternTemplateRepository = patternTemplateRepository;
        this.patternAnalysisSelectorMapping = patternAnalysisSelectorMapping;
        this.patternAnalysisTaskExecutor = patternAnalysisTaskExecutor;
        this.patternConditionProviderChain = patternConditionProviderChain;
        this.analyzerStatusCache = analyzerStatusCache;
        this.messageBus = messageBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeTestItems(Launch launch, Set<AnalyzeItemsMode> analyzeModes) {
        BusinessRule.expect(this.analyzerStatusCache.getStartedAnalyzers(launch.getId()), (Predicate)Predicates.not(started -> started.contains("patternAnalyzer"))).verify(ErrorType.PATTERN_ANALYSIS_ERROR, new Object[]{"Pattern analysis is still in progress."});
        try {
            this.analyzerStatusCache.analyzeStarted("patternAnalyzer", launch.getId(), launch.getProjectId());
            ConvertibleCondition commonItemCondition = this.createCommonItemCondition(launch.getId(), analyzeModes);
            this.patternTemplateRepository.findAllByProjectIdAndEnabled(launch.getProjectId(), true).forEach(patternTemplate -> this.patternAnalysisTaskExecutor.execute(() -> {
                Filter filter = this.createItemFilter(commonItemCondition, patternTemplate.getName());
                List<PatternTemplateTestItemPojo> patternTemplateTestItems = this.patternAnalysisSelectorMapping.get(patternTemplate.getTemplateType()).selectItemsByPattern((Queryable)filter, (PatternTemplate)patternTemplate);
                this.patternTemplateRepository.saveInBatch(patternTemplateTestItems);
                PatternTemplateActivityResource patternTemplateActivityResource = PatternTemplateConverter.TO_ACTIVITY_RESOURCE.apply((PatternTemplate)patternTemplate);
                patternTemplateTestItems.forEach(patternItem -> {
                    PatternMatchedEvent patternMatchedEvent = new PatternMatchedEvent(patternItem.getPatternTemplateId(), patternItem.getTestItemId(), patternTemplateActivityResource);
                    this.messageBus.publishActivity(patternMatchedEvent);
                });
            }));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.analyzerStatusCache.analyzeFinished("patternAnalyzer", launch.getId());
        }
    }

    private ConvertibleCondition createCommonItemCondition(Long launchId, Set<AnalyzeItemsMode> analyzeModes) {
        CompositeFilterCondition testItemCondition = new CompositeFilterCondition((List)Lists.newArrayList((Object[])new ConvertibleCondition[]{FilterCondition.builder().eq("launchId", String.valueOf(launchId)).build()}));
        this.patternConditionProviderChain.provideCondition(analyzeModes).ifPresent(condition -> testItemCondition.getConditions().add(condition));
        return testItemCondition;
    }

    private Filter createItemFilter(ConvertibleCondition commonItemCondition, String patternTemplateName) {
        return Filter.builder().withTarget(TestItem.class).withCondition(commonItemCondition).withCondition((ConvertibleCondition)FilterCondition.builder().withCondition(Condition.ANY).withNegative(true).withSearchCriteria("patternName").withValue(patternTemplateName).build()).build();
    }
}

