/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.pattern.CreatePatternTemplateHandler;
import com.epam.ta.reportportal.dao.PatternTemplateRepository;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.ws.converter.builders.PatternTemplateBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.project.config.pattern.CreatePatternTemplateRQ;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateStringPatternTemplateHandler
implements CreatePatternTemplateHandler {
    private final PatternTemplateRepository patternTemplateRepository;

    @Autowired
    public CreateStringPatternTemplateHandler(PatternTemplateRepository patternTemplateRepository) {
        this.patternTemplateRepository = patternTemplateRepository;
    }

    @Override
    public PatternTemplate createPatternTemplate(Long projectId, CreatePatternTemplateRQ createPatternTemplateRQ) {
        BusinessRule.expect((Object)this.patternTemplateRepository.existsByProjectIdAndNameIgnoreCase(projectId, createPatternTemplateRQ.getName()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{createPatternTemplateRQ.getName()});
        PatternTemplate patternTemplate = new PatternTemplateBuilder().withCreateRequest(createPatternTemplateRQ).withProjectId(projectId).get();
        return (PatternTemplate)this.patternTemplateRepository.save((Object)patternTemplate);
    }
}

