/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AnalyzerStatusCache {
    public static final String AUTO_ANALYZER_KEY = "autoAnalyzer";
    public static final String PATTERN_ANALYZER_KEY = "patternAnalyzer";
    private static final int CACHE_ITEM_LIVE = 10;
    private static final int MAXIMUM_SIZE = 50000;
    private Map<String, Cache<Long, Long>> analyzeStatus;

    public AnalyzerStatusCache() {
        Cache autoAnalysisStatusCache = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        Cache patternAnalysisCache = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        this.analyzeStatus = ImmutableMap.builder().put((Object)AUTO_ANALYZER_KEY, (Object)autoAnalysisStatusCache).put((Object)PATTERN_ANALYZER_KEY, (Object)patternAnalysisCache).build();
    }

    public AnalyzerStatusCache(Map<String, Cache<Long, Long>> analyzeStatus) {
        this.analyzeStatus = analyzeStatus;
    }

    public boolean analyzeStarted(String analyzerKey, Long launchId, Long projectId) {
        Cache<Long, Long> analysisCache = this.analyzeStatus.get(analyzerKey);
        if (analysisCache == null) {
            return false;
        }
        analysisCache.put((Object)launchId, (Object)projectId);
        return true;
    }

    public boolean analyzeFinished(String analyzerKey, Long launchId) {
        Cache<Long, Long> analysisCache = this.analyzeStatus.get(analyzerKey);
        if (analysisCache == null) {
            return false;
        }
        analysisCache.invalidate((Object)launchId);
        return true;
    }

    public Optional<Cache<Long, Long>> getAnalyzeStatus(String analyzerKey) {
        return Optional.ofNullable(this.analyzeStatus.get(analyzerKey));
    }

    public Set<String> getStartedAnalyzers(Long launchId) {
        return this.analyzeStatus.entrySet().stream().filter(entry -> ((Cache)entry.getValue()).asMap().containsKey(launchId)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getAnalyzers() {
        return this.analyzeStatus.keySet();
    }
}

