/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.admin;

import com.epam.ta.reportportal.core.admin.ServerAdminHandler;
import com.epam.ta.reportportal.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.entity.ServerSettings;
import com.epam.ta.reportportal.ws.converter.converters.ServerSettingsConverter;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.settings.AnalyticsResource;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerAdminHandlerImpl
implements ServerAdminHandler {
    private final ServerSettingsRepository serverSettingsRepository;

    @Autowired
    public ServerAdminHandlerImpl(ServerSettingsRepository serverSettingsRepository) {
        this.serverSettingsRepository = serverSettingsRepository;
    }

    @Override
    public Map<String, String> getServerSettings() {
        return ServerSettingsConverter.TO_RESOURCE.apply(this.serverSettingsRepository.selectServerSettings());
    }

    @Override
    public OperationCompletionRS saveAnalyticsSettings(AnalyticsResource analyticsResource) {
        String analyticsType = analyticsResource.getType();
        Map<String, ServerSettings> serverAnalyticsDetails = this.findServerSettings().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("server.analytics.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Object formattedAnalyticsType = analyticsType.startsWith("server.analytics.") ? analyticsType : "server.analytics." + analyticsType;
        ServerSettings analyticsDetails = Optional.ofNullable(serverAnalyticsDetails.get(formattedAnalyticsType)).orElseGet(ServerSettings::new);
        analyticsDetails.setKey((String)formattedAnalyticsType);
        analyticsDetails.setValue(String.valueOf(Optional.ofNullable(analyticsResource.getEnabled()).orElse(false)));
        this.serverSettingsRepository.save((Object)analyticsDetails);
        return new OperationCompletionRS("Server Settings were successfully updated.");
    }

    private Map<String, ServerSettings> findServerSettings() {
        return this.serverSettingsRepository.selectServerSettings().stream().collect(Collectors.toMap(ServerSettings::getKey, s -> s, (prev, curr) -> prev));
    }
}

