/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Objects;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

abstract class BaseProjectPermission
implements Permission {
    BaseProjectPermission() {
    }

    @Override
    public boolean isAllowed(Authentication authentication, Object projectName) {
        if (!authentication.isAuthenticated()) {
            return false;
        }
        OAuth2Authentication oauth = (OAuth2Authentication)authentication;
        ReportPortalUser rpUser = (ReportPortalUser)oauth.getUserAuthentication().getPrincipal();
        BusinessRule.expect((Object)rpUser, Objects::nonNull).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        BusinessRule.expect((Object)Optional.ofNullable(rpUser.getProjectDetails()).map(d -> d.containsKey(projectName.toString())).orElse(false), it -> it.equals(true)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        ProjectRole role = ((ReportPortalUser.ProjectDetails)rpUser.getProjectDetails().get(projectName.toString())).getProjectRole();
        return this.checkAllowed(rpUser, projectName.toString(), role);
    }

    protected abstract boolean checkAllowed(ReportPortalUser var1, String var2, ProjectRole var3);
}

