/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.querygen.FilterTarget;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SortArgumentResolver
extends SortHandlerMethodArgumentResolver {
    public Sort resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Sort defaultSort = super.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (null != parameter.getParameterAnnotation(SortFor.class)) {
            Class<?> domainModelType = ((SortFor)parameter.getParameterAnnotation(SortFor.class)).value();
            FilterTarget filterTarget = FilterTarget.findByClass(domainModelType);
            defaultSort = defaultSort.and(Sort.by((String[])new String[]{"id"}));
            return Sort.by(StreamSupport.stream(defaultSort.spliterator(), false).map(order -> {
                Optional criteriaHolder = filterTarget.getCriteriaByFilter(order.getProperty());
                BusinessRule.expect((Object)criteriaHolder, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.INCORRECT_SORTING_PARAMETERS, new Object[]{order.getProperty()});
                return new Sort.Order(order.getDirection(), order.getProperty());
            }).collect(Collectors.toList()));
        }
        return defaultSort;
    }
}

