/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import com.epam.ta.reportportal.ws.resolver.JacksonViewReturnValueHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class JsonViewSupportFactoryBean
implements InitializingBean {
    @Autowired
    private RequestMappingHandlerAdapter adapter;

    public void afterPropertiesSet() {
        List handlers = this.adapter.getReturnValueHandlers();
        this.adapter.setReturnValueHandlers(this.decorateHandlers(handlers));
    }

    private List<HandlerMethodReturnValueHandler> decorateHandlers(List<HandlerMethodReturnValueHandler> handlers) {
        ArrayList<HandlerMethodReturnValueHandler> updatedHandlers = new ArrayList<HandlerMethodReturnValueHandler>(handlers.size());
        for (HandlerMethodReturnValueHandler handler : handlers) {
            if (handler instanceof RequestResponseBodyMethodProcessor) {
                updatedHandlers.add(new JacksonViewReturnValueHandler(handler));
                continue;
            }
            updatedHandlers.add(handler);
        }
        return Collections.unmodifiableList(updatedHandlers);
    }
}

