/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import com.epam.ta.reportportal.ws.resolver.JacksonViewAware;
import com.epam.ta.reportportal.ws.resolver.ResponseView;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

class JacksonViewReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final HandlerMethodReturnValueHandler delegate;

    public JacksonViewReturnValueHandler(HandlerMethodReturnValueHandler delegate) {
        this.delegate = delegate;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.delegate.supportsReturnType(returnType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Class<?> viewClass = this.getDeclaredViewClass(returnType);
        if (viewClass != null) {
            returnValue = this.wrapResult(returnValue, viewClass);
        }
        this.delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }

    private Class<?> getDeclaredViewClass(MethodParameter returnType) {
        ResponseView annotation = (ResponseView)returnType.getMethodAnnotation(ResponseView.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    private Object wrapResult(Object result, Class<?> viewClass) {
        return new JacksonViewAware(result, viewClass);
    }
}

