/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.rabbit;

import com.epam.ta.reportportal.model.notification.EmailNotificationRQ;
import com.epam.ta.reportportal.util.email.strategy.EmailNotificationStrategy;
import com.epam.ta.reportportal.util.email.strategy.EmailTemplate;
import java.util.Map;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class EmailNotificationConsumer {
    private final Map<EmailTemplate, EmailNotificationStrategy> emailNotificationStrategyMapping;

    @Autowired
    public EmailNotificationConsumer(Map<EmailTemplate, EmailNotificationStrategy> emailNotificationStrategyMapping) {
        this.emailNotificationStrategyMapping = emailNotificationStrategyMapping;
    }

    @RabbitListener(queues={"notification.email"}, containerFactory="rabbitListenerContainerFactory")
    public void onEvent(@Payload EmailNotificationRQ rq) {
        EmailTemplate emailTemplate = EmailTemplate.fromString(rq.getTemplate());
        this.emailNotificationStrategyMapping.get((Object)emailTemplate).sendEmail(rq.getRecipient(), rq.getParams());
    }
}

