/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.entity.dashboard.DashboardWidget;
import com.epam.ta.reportportal.entity.dashboard.DashboardWidgetId;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.model.Position;
import com.epam.ta.reportportal.model.Size;
import com.epam.ta.reportportal.model.activity.WidgetActivityResource;
import com.epam.ta.reportportal.model.dashboard.DashboardResource;
import com.epam.ta.reportportal.model.widget.ContentParameters;
import com.epam.ta.reportportal.model.widget.WidgetResource;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class WidgetConverter {
    public static final Function<DashboardWidget, DashboardResource.WidgetObjectModel> TO_OBJECT_MODEL = dashboardWidget -> {
        DashboardResource.WidgetObjectModel objectModel = new DashboardResource.WidgetObjectModel();
        objectModel.setName(dashboardWidget.getWidgetName());
        objectModel.setWidgetType(dashboardWidget.getWidgetType());
        objectModel.setWidgetId(dashboardWidget.getId().getWidgetId());
        objectModel.setWidgetPosition(new Position(dashboardWidget.getPositionX(), dashboardWidget.getPositionY()));
        objectModel.setWidgetSize(new Size(dashboardWidget.getWidth(), dashboardWidget.getHeight()));
        Optional.ofNullable(dashboardWidget.getWidget().getWidgetOptions()).ifPresent(wo -> objectModel.setWidgetOptions(wo.getOptions()));
        return objectModel;
    };
    public static final Function<Widget, WidgetResource> TO_WIDGET_RESOURCE = widget -> {
        WidgetResource widgetResource = new WidgetResource();
        widgetResource.setWidgetId(widget.getId());
        widgetResource.setName(widget.getName());
        widgetResource.setWidgetType(widget.getWidgetType());
        widgetResource.setDescription(widget.getDescription());
        widgetResource.setOwner(widget.getOwner());
        Optional.ofNullable(widget.getFilters()).ifPresent(filter -> widgetResource.setAppliedFilters(UserFilterConverter.FILTER_SET_TO_FILTER_RESOURCE.apply((Set<UserFilter>)filter)));
        ContentParameters contentParameters = new ContentParameters();
        contentParameters.setItemsCount(widget.getItemsCount());
        Optional.ofNullable(widget.getWidgetOptions()).ifPresent(wo -> contentParameters.setWidgetOptions(wo.getOptions()));
        contentParameters.setContentFields(Lists.newArrayList((Iterable)widget.getContentFields()));
        widgetResource.setContentParameters(contentParameters);
        return widgetResource;
    };
    public static final Function<Widget, WidgetActivityResource> TO_ACTIVITY_RESOURCE = widget -> {
        WidgetActivityResource resource = new WidgetActivityResource();
        resource.setId(widget.getId());
        resource.setProjectId(widget.getProject().getId());
        resource.setName(widget.getName());
        resource.setDescription(widget.getDescription());
        resource.setItemsCount(widget.getItemsCount());
        resource.setContentFields(Sets.newHashSet((Iterable)widget.getContentFields()));
        Optional.ofNullable(widget.getWidgetOptions()).ifPresent(wo -> resource.setWidgetOptions(wo.getOptions()));
        return resource;
    };

    public static DashboardWidget toDashboardWidget(DashboardResource.WidgetObjectModel model, Dashboard dashboard, Widget widget, boolean isCreatedOn) {
        DashboardWidgetId id = new DashboardWidgetId();
        id.setDashboardId(dashboard.getId());
        id.setWidgetId(model.getWidgetId());
        DashboardWidget dashboardWidget = new DashboardWidget();
        dashboardWidget.setId(id);
        dashboardWidget.setWidgetType(widget.getWidgetType());
        dashboardWidget.setWidgetName(widget.getName());
        dashboardWidget.setPositionX(model.getWidgetPosition().getX());
        dashboardWidget.setPositionY(model.getWidgetPosition().getY());
        dashboardWidget.setWidth(model.getWidgetSize().getWidth());
        dashboardWidget.setHeight(model.getWidgetSize().getHeight());
        dashboardWidget.setDashboard(dashboard);
        dashboardWidget.setWidget(widget);
        dashboardWidget.setCreatedOn(isCreatedOn);
        dashboardWidget.setWidgetOwner(widget.getOwner());
        return dashboardWidget;
    }
}

