/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.entity.ServerSettings;
import com.epam.ta.reportportal.model.settings.ServerSettingsResource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public final class ServerSettingsConverter {
    public static final Function<ServerSettings, ServerSettingsResource> TO_RESOURCE = serverSettings -> new ServerSettingsResource(serverSettings.getKey(), serverSettings.getValue());
    public static final Function<List<ServerSettings>, Map<String, String>> TO_RESOURCES = serverSettings -> {
        BusinessRule.expect((Object)serverSettings, CollectionUtils::isNotEmpty).verify(ErrorType.SERVER_SETTINGS_NOT_FOUND, new Object[]{"default"});
        return serverSettings.stream().collect(Collectors.toMap(ServerSettings::getKey, ServerSettings::getValue));
    };

    private ServerSettingsConverter() {
    }
}

