/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.core.log.impl.PagedLogResource;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.log.LogFull;
import com.epam.ta.reportportal.model.log.LogResource;
import com.epam.ta.reportportal.model.log.SearchLogRs;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public final class LogConverter {
    public static final Function<LogFull, LogResource> TO_RESOURCE = model -> {
        Preconditions.checkNotNull((Object)model);
        LogResource resource = new LogResource();
        LogConverter.fillWithLogContent(model, resource);
        return resource;
    };
    public static final BiFunction<LogFull, PagedLogResource, PagedLogResource> FILL_WITH_LOG_CONTENT = (model, pagedLog) -> {
        LogConverter.fillWithLogContent(model, pagedLog);
        return pagedLog;
    };
    public static final Function<LogFull, SearchLogRs.LogEntry> TO_LOG_ENTRY = log -> {
        SearchLogRs.LogEntry logEntry = new SearchLogRs.LogEntry();
        logEntry.setMessage(log.getLogMessage());
        logEntry.setLevel(LogLevel.toLevel((int)log.getLogLevel()).name());
        return logEntry;
    };
    public static final Function<LogFull, Log> LOG_FULL_TO_LOG = logFull -> {
        Log log = new Log();
        log.setAttachment(logFull.getAttachment());
        log.setClusterId(logFull.getClusterId());
        log.setId(logFull.getId());
        log.setLastModified(logFull.getLastModified());
        log.setLaunch(logFull.getLaunch());
        log.setLogLevel(logFull.getLogLevel());
        log.setLogMessage(logFull.getLogMessage());
        log.setLogTime(logFull.getLogTime());
        log.setProjectId(logFull.getProjectId());
        log.setTestItem(logFull.getTestItem());
        log.setUuid(logFull.getUuid());
        return log;
    };
    public static final Function<Log, LogFull> LOG_TO_LOG_FULL = log -> {
        LogFull logFull = new LogFull();
        logFull.setAttachment(log.getAttachment());
        logFull.setClusterId(log.getClusterId());
        logFull.setId(log.getId());
        logFull.setLastModified(log.getLastModified());
        logFull.setLaunch(log.getLaunch());
        logFull.setLogLevel(log.getLogLevel());
        logFull.setLogMessage(log.getLogMessage());
        logFull.setLogTime(log.getLogTime());
        logFull.setProjectId(log.getProjectId());
        logFull.setTestItem(log.getTestItem());
        logFull.setUuid(log.getUuid());
        return logFull;
    };

    private LogConverter() {
    }

    private static void fillWithLogContent(LogFull model, LogResource resource) {
        resource.setId(model.getId());
        resource.setUuid(model.getUuid());
        resource.setMessage(Optional.ofNullable(model.getLogMessage()).orElse("NULL"));
        resource.setLogTime(model.getLogTime());
        if (LogConverter.isBinaryDataExists(model)) {
            LogResource.BinaryContent binaryContent = new LogResource.BinaryContent();
            binaryContent.setBinaryDataId(String.valueOf(model.getAttachment().getId()));
            binaryContent.setContentType(model.getAttachment().getContentType());
            binaryContent.setThumbnailId(model.getAttachment().getThumbnailId());
            resource.setBinaryContent(binaryContent);
        }
        Optional.ofNullable(model.getTestItem()).ifPresent(testItem -> resource.setItemId(testItem.getItemId()));
        Optional.ofNullable(model.getLaunch()).ifPresent(launch -> resource.setLaunchId(launch.getId()));
        Optional.ofNullable(model.getLogLevel()).ifPresent(level -> resource.setLevel(LogLevel.toLevel((int)level).toString()));
    }

    private static boolean isBinaryDataExists(LogFull log) {
        return Optional.ofNullable(log.getAttachment()).map(a -> StringUtils.isNotEmpty((CharSequence)a.getContentType()) || StringUtils.isNotEmpty((CharSequence)a.getThumbnailId()) || StringUtils.isNotEmpty((CharSequence)a.getFileId())).orElse(false);
    }
}

