/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.reporting.ItemAttributeResource;
import com.epam.ta.reportportal.ws.reporting.ItemAttributesRQ;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ItemAttributeConverter {
    public static final int MAX_ATTRIBUTE_LENGTH = 512;
    public static final Function<ItemAttributeResource, ItemAttribute> FROM_RESOURCE = it -> {
        String value;
        ItemAttribute itemAttribute = new ItemAttribute();
        String key = it.getKey();
        if (key != null && key.length() > 512) {
            key = key.substring(0, 512);
        }
        if ((value = it.getValue()) != null && value.length() > 512) {
            value = value.substring(0, 512);
        }
        itemAttribute.setKey(key);
        itemAttribute.setValue(value);
        if (it instanceof ItemAttributesRQ) {
            ItemAttributesRQ itemAttributesRQ = (ItemAttributesRQ)it;
            itemAttribute.setSystem(Boolean.valueOf(itemAttributesRQ.isSystem()));
        } else {
            itemAttribute.setSystem(Boolean.valueOf(false));
        }
        return itemAttribute;
    };
    public static final BiFunction<ItemAttributesRQ, Launch, ItemAttribute> TO_LAUNCH_ATTRIBUTE = (model, launch) -> {
        ItemAttribute itemAttribute = new ItemAttribute(model.getKey(), model.getValue(), Boolean.valueOf(model.isSystem()));
        itemAttribute.setLaunch(launch);
        return itemAttribute;
    };
    public static final BiFunction<ItemAttributesRQ, TestItem, ItemAttribute> TO_TEST_ITEM_ATTRIBUTE = (model, item) -> {
        ItemAttribute itemAttribute = new ItemAttribute(model.getKey(), model.getValue(), Boolean.valueOf(model.isSystem()));
        itemAttribute.setTestItem(item);
        return itemAttribute;
    };

    private ItemAttributeConverter() {
    }
}

