/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.core.integration.util.property.AuthProperties;
import com.epam.ta.reportportal.core.integration.util.property.BtsProperties;
import com.epam.ta.reportportal.core.integration.util.property.SauceLabsProperties;
import com.epam.ta.reportportal.entity.EmailSettingsEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationParams;
import com.epam.ta.reportportal.model.activity.IntegrationActivityResource;
import com.epam.ta.reportportal.model.integration.AuthFlowEnum;
import com.epam.ta.reportportal.model.integration.IntegrationResource;
import com.epam.ta.reportportal.model.integration.IntegrationTypeResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public final class IntegrationConverter {
    private static final List<String> IGNORE_FIELDS = List.of(EmailSettingsEnum.PASSWORD.getAttribute(), SauceLabsProperties.ACCESS_TOKEN.getName(), BtsProperties.OAUTH_ACCESS_KEY.getName(), BtsProperties.API_TOKEN.getName(), AuthProperties.MANAGER_PASSWORD.getName());
    private static final Predicate<Map.Entry<String, Object>> IGNORE_FIELDS_CONDITION = entry -> IGNORE_FIELDS.stream().noneMatch(field -> field.equalsIgnoreCase((String)entry.getKey()));
    public static final Function<Integration, IntegrationResource> TO_INTEGRATION_RESOURCE = integration -> {
        IntegrationResource resource = new IntegrationResource();
        resource.setId(integration.getId());
        resource.setName(integration.getName());
        resource.setCreator(integration.getCreator());
        resource.setCreationDate(integration.getCreationDate());
        resource.setEnabled(integration.isEnabled());
        Optional.ofNullable(integration.getProject()).ifPresent(p -> resource.setProjectId(p.getId()));
        Optional.ofNullable(integration.getParams()).flatMap(IntegrationConverter::convertToResourceParams).ifPresent(resource::setIntegrationParams);
        IntegrationTypeResource type = new IntegrationTypeResource();
        type.setId(integration.getType().getId());
        type.setName(integration.getType().getName());
        type.setEnabled(integration.getType().isEnabled());
        type.setCreationDate(integration.getType().getCreationDate());
        type.setGroupType(integration.getType().getIntegrationGroup().name());
        Optional.ofNullable(integration.getType().getDetails()).ifPresent(it -> type.setDetails(it.getDetails()));
        Optional.ofNullable(integration.getType().getAuthFlow()).ifPresent(it -> type.setAuthFlow(AuthFlowEnum.valueOf(it.name())));
        resource.setIntegrationType(type);
        return resource;
    };
    public static final Function<Integration, IntegrationActivityResource> TO_ACTIVITY_RESOURCE = integration -> {
        IntegrationActivityResource resource = new IntegrationActivityResource();
        resource.setId(integration.getId());
        resource.setName(integration.getName());
        Optional.ofNullable(integration.getProject()).ifPresent(p -> {
            resource.setProjectId(p.getId());
            resource.setProjectName(p.getName());
        });
        resource.setTypeName(integration.getType().getName());
        return resource;
    };

    private static Optional<Map<String, Object>> convertToResourceParams(IntegrationParams it) {
        return Optional.ofNullable(it.getParams()).map(p -> p.entrySet().stream().filter(IGNORE_FIELDS_CONDITION).collect(HashMap::new, (resourceParams, entry) -> resourceParams.put((String)entry.getKey(), entry.getValue()), Map::putAll));
    }

    private IntegrationConverter() {
    }
}

