/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.Metadata;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.entity.user.UserType;
import com.epam.ta.reportportal.model.user.CreateUserRQConfirm;
import com.epam.ta.reportportal.model.user.CreateUserRQFull;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public class UserBuilder
implements Supplier<User> {
    public static final String USER_LAST_LOGIN = "last_login";
    private final User user;

    public UserBuilder() {
        this.user = new User();
        this.user.setActive(Boolean.TRUE);
        this.user.setUuid(UUID.randomUUID());
    }

    public UserBuilder(User user) {
        this.user = user;
    }

    public UserBuilder addCreateUserRQ(CreateUserRQConfirm request) {
        Optional.ofNullable(request).ifPresent(r -> this.fillUser(r.getLogin(), r.getEmail(), r.getFullName(), null, true, UserType.INTERNAL.name()));
        return this;
    }

    public UserBuilder addCreateUserFullRQ(CreateUserRQFull request) {
        Optional.ofNullable(request).ifPresent(it -> this.fillUser(it.getLogin(), it.getEmail(), it.getFullName(), it.getExternalId(), it.isActive(), request.getAccountType()));
        return this;
    }

    public UserBuilder addPassword(String password) {
        this.user.setPassword(password);
        return this;
    }

    public UserBuilder addUserRole(UserRole userRole) {
        this.user.setRole(userRole);
        return this;
    }

    @Override
    public User get() {
        return this.user;
    }

    private void fillUser(String login, String email, String fullName, String externalId, boolean active, String type) {
        this.user.setLogin(EntityUtils.normalizeId((String)login));
        Optional.ofNullable(email).map(String::trim).map(EntityUtils::normalizeId).ifPresent(arg_0 -> ((User)this.user).setEmail(arg_0));
        this.user.setFullName(fullName);
        this.user.setExternalId(externalId);
        this.user.setUserType(UserType.valueOf((String)Optional.ofNullable(type).orElse("INTERNAL")));
        this.user.setExpired(false);
        HashMap<String, Long> meta = new HashMap<String, Long>();
        meta.put(USER_LAST_LOGIN, Instant.now().toEpochMilli());
        this.user.setMetadata(new Metadata(meta));
    }
}

