/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.model.PagedResponse;
import com.epam.ta.reportportal.ws.converter.ResourceAssembler;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Sort;

public abstract class PagedResourcesAssembler<T, R>
extends ResourceAssembler<T, R> {
    public static <T> Function<Page<T>, com.epam.ta.reportportal.model.Page<T>> pageConverter() {
        return page -> new com.epam.ta.reportportal.model.Page(page.getContent(), new Page.PageMetadata(page.getSize(), (long)page.getNumber() + 1L, page.getTotalElements(), page.getTotalPages()));
    }

    public static <T, R> Function<Page<T>, com.epam.ta.reportportal.model.Page<R>> pageConverter(Function<T, R> modelConverter) {
        return page -> PagedResourcesAssembler.pageConverter().apply(page.map(modelConverter));
    }

    public static <T> Function<Page<T>, PagedResponse<T>> pagedResponseConverter() {
        return page -> new PagedResponse(page.getPageable().getOffset(), page.getSize(), page.getTotalElements(), ((Sort.Order)page.getSort().toList().get(0)).getProperty(), ((Sort.Order)page.getSort().toList().get(0)).getDirection().toString(), page.getContent());
    }

    public static <T, R> Function<Page<T>, PagedResponse<R>> pagedResponseConverter(Function<T, R> modelConverter) {
        return page -> PagedResourcesAssembler.pagedResponseConverter().apply(page.map(modelConverter));
    }

    public static <T, R> Function<Page<T>, com.epam.ta.reportportal.model.Page<R>> pageMultiConverter(Function<List<T>, List<R>> modelConverter) {
        return page -> PagedResourcesAssembler.pageConverter().apply((Page<PageImpl>)new PageImpl((List)modelConverter.apply(page.getContent()), page.getPageable(), page.getTotalElements()));
    }

    @Deprecated
    public com.epam.ta.reportportal.model.Page<R> toPagedResources(Page<T> content) {
        Preconditions.checkNotNull(content, (Object)"Content should be null");
        return new com.epam.ta.reportportal.model.Page(this.toResources(content), new Page.PageMetadata(content.getSize(), (long)content.getNumber() + 1L, content.getTotalElements(), content.getTotalPages()));
    }
}

