/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.CreateWidgetHandler;
import com.epam.ta.reportportal.core.widget.GetWidgetHandler;
import com.epam.ta.reportportal.core.widget.UpdateWidgetHandler;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.model.widget.WidgetPreviewRQ;
import com.epam.ta.reportportal.model.widget.WidgetRQ;
import com.epam.ta.reportportal.model.widget.WidgetResource;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@RequestMapping(value={"/v1/{projectName}/widget"})
@Tag(name="Widget", description="Widgets API collection")
public class WidgetController {
    private final ProjectExtractor projectExtractor;
    private final CreateWidgetHandler createWidgetHandler;
    private final UpdateWidgetHandler updateWidgetHandler;
    private final GetWidgetHandler getWidgetHandler;

    @Autowired
    public WidgetController(ProjectExtractor projectExtractor, CreateWidgetHandler createWidgetHandler, UpdateWidgetHandler updateWidgetHandler, GetWidgetHandler getWidgetHandler) {
        this.projectExtractor = projectExtractor;
        this.createWidgetHandler = createWidgetHandler;
        this.updateWidgetHandler = updateWidgetHandler;
        this.getWidgetHandler = getWidgetHandler;
    }

    @Transactional
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create a new widget")
    public EntryCreatedRS createWidget(@RequestBody @Validated WidgetRQ createWidget, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String projectName) {
        return this.createWidgetHandler.createWidget(createWidget, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{widgetId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get widget by ID")
    public WidgetResource getWidget(@PathVariable String projectName, @PathVariable Long widgetId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getWidgetHandler.getWidget(widgetId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"multilevel/{widgetId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get multilevel widget by ID")
    public WidgetResource getWidget(@PathVariable String projectName, @PathVariable Long widgetId, @RequestParam(required=false, name="attributes") String[] attributes, @RequestParam MultiValueMap<String, String> params, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getWidgetHandler.getWidget(widgetId, ArrayUtils.nullToEmpty((String[])attributes), params, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"/preview"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get widget preview")
    public Map<String, ?> getWidgetPreview(@PathVariable String projectName, @RequestBody @Validated WidgetPreviewRQ previewRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getWidgetHandler.getWidgetPreview(previewRQ, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional
    @PutMapping(value={"/{widgetId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update specified widget")
    public OperationCompletionRS updateWidget(@PathVariable String projectName, @PathVariable Long widgetId, @RequestBody @Validated WidgetRQ updateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateWidgetHandler.updateWidget(widgetId, updateRQ, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/names/all"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Load all widget names which belong to a user")
    public Page<Object> getWidgetNames(@PathVariable String projectName, @SortFor(value=Widget.class) Pageable pageable, @FilterFor(value=Widget.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getWidgetHandler.getOwnNames(this.projectExtractor.extractProjectDetails(user, projectName), pageable, filter, user);
    }
}

