/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.launch.util.LinkGenerator;
import com.epam.ta.reportportal.core.user.ApiKeyHandler;
import com.epam.ta.reportportal.core.user.CreateUserHandler;
import com.epam.ta.reportportal.core.user.DeleteUserHandler;
import com.epam.ta.reportportal.core.user.EditUserHandler;
import com.epam.ta.reportportal.core.user.GetUserHandler;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.model.ApiKeyRQ;
import com.epam.ta.reportportal.model.ApiKeyRS;
import com.epam.ta.reportportal.model.ApiKeysRS;
import com.epam.ta.reportportal.model.DeleteBulkRS;
import com.epam.ta.reportportal.model.ModelViews;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.model.YesNoRS;
import com.epam.ta.reportportal.model.user.ChangePasswordRQ;
import com.epam.ta.reportportal.model.user.CreateUserBidRS;
import com.epam.ta.reportportal.model.user.CreateUserRQ;
import com.epam.ta.reportportal.model.user.CreateUserRQConfirm;
import com.epam.ta.reportportal.model.user.CreateUserRQFull;
import com.epam.ta.reportportal.model.user.CreateUserRS;
import com.epam.ta.reportportal.model.user.EditUserRQ;
import com.epam.ta.reportportal.model.user.ResetPasswordRQ;
import com.epam.ta.reportportal.model.user.RestorePasswordRQ;
import com.epam.ta.reportportal.model.user.UserBidRS;
import com.epam.ta.reportportal.model.user.UserResource;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.epam.ta.reportportal.ws.resolver.ActiveRole;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.ResponseView;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/users"})
@Tag(name="User", description="Users API collection")
public class UserController {
    private final CreateUserHandler createUserMessageHandler;
    private final EditUserHandler editUserMessageHandler;
    private final DeleteUserHandler deleteUserHandler;
    private final ApiKeyHandler apiKeyHandler;
    private final GetUserHandler getUserHandler;
    private final GetJasperReportHandler<User> jasperReportHandler;

    @Autowired
    public UserController(CreateUserHandler createUserMessageHandler, EditUserHandler editUserMessageHandler, DeleteUserHandler deleteUserHandler, GetUserHandler getUserHandler, @Qualifier(value="userJasperReportHandler") GetJasperReportHandler<User> jasperReportHandler, ApiKeyHandler apiKeyHandler) {
        this.createUserMessageHandler = createUserMessageHandler;
        this.editUserMessageHandler = editUserMessageHandler;
        this.deleteUserHandler = deleteUserHandler;
        this.getUserHandler = getUserHandler;
        this.jasperReportHandler = jasperReportHandler;
        this.apiKeyHandler = apiKeyHandler;
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @Operation(summary="Create specified user", description="Allowable only for users with administrator role")
    public CreateUserRS createUserByAdmin(@RequestBody @Validated CreateUserRQFull rq, @AuthenticationPrincipal ReportPortalUser currentUser, HttpServletRequest request) {
        return this.createUserMessageHandler.createUserByAdmin(rq, currentUser, LinkGenerator.composeBaseUrl(request));
    }

    @Transactional
    @PostMapping(value={"/bid"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="(hasPermission(#createUserRQ.getDefaultProject(), 'projectManagerPermission')) || hasRole('ADMINISTRATOR')")
    @Operation(summary="Register invitation for user who will be created")
    public CreateUserBidRS createUserBid(@RequestBody @Validated CreateUserRQ createUserRQ, @AuthenticationPrincipal ReportPortalUser currentUser, HttpServletRequest request) {
        return this.createUserMessageHandler.createUserBid(createUserRQ, currentUser, LinkGenerator.composeBaseUrl(request));
    }

    @PostMapping(value={"/registration"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Activate invitation and create user in system")
    public CreateUserRS createUser(@RequestBody @Validated CreateUserRQConfirm request, @RequestParam(value="uuid") String uuid) {
        return this.createUserMessageHandler.createUser(request, uuid);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/registration"})
    public UserBidRS getUserBidInfo(@RequestParam(value="uuid") String uuid) {
        return this.getUserHandler.getBidInformation(uuid);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete specified user")
    public OperationCompletionRS deleteUser(@PathVariable(value="id") Long userId, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.deleteUserHandler.deleteUser(userId, currentUser);
    }

    @DeleteMapping
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete specified users by ids")
    public DeleteBulkRS deleteUsers(@RequestParam(value="ids") List<Long> ids, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteUserHandler.deleteUsers(ids, user);
    }

    @Transactional
    @PutMapping(value={"/{login}"})
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name)||hasRole('ADMINISTRATOR')")
    @Operation(summary="Edit specified user", description="Only for administrators and profile's owner")
    public OperationCompletionRS editUser(@PathVariable String login, @RequestBody @Validated EditUserRQ editUserRQ, @ActiveRole UserRole role, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.editUserMessageHandler.editUser(EntityUtils.normalizeId((String)login), editUserRQ, currentUser);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{login}"})
    @ResponseView(value=ModelViews.FullUserView.class)
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name)||hasRole('ADMINISTRATOR')")
    @Operation(summary="Return information about specified user", description="Only for administrators and profile's owner")
    public UserResource getUser(@PathVariable String login, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.getUserHandler.getUser(EntityUtils.normalizeId((String)login), currentUser);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"", "/"})
    @Operation(summary="Return information about current logged-in user")
    public UserResource getMyself(@AuthenticationPrincipal UserDetails currentUser) {
        return this.getUserHandler.getUser((ReportPortalUser)currentUser);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/all"})
    @ResponseView(value=ModelViews.FullUserView.class)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @Operation(summary="Return information about all users", description="Allowable only for users with administrator role")
    public Page<UserResource> getUsers(@FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, @FilterFor(value=User.class) Queryable queryable, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.getUserHandler.getAllUsers((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, queryable}), pageable);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/registration/info"})
    public YesNoRS validateInfo(@RequestParam(value="username", required=false) String username, @RequestParam(value="email", required=false) String email) {
        return this.getUserHandler.validateInfo(username, email);
    }

    @Transactional
    @PostMapping(value={"/password/restore"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Create a restore password request")
    public OperationCompletionRS restorePassword(@RequestBody @Validated RestorePasswordRQ rq, HttpServletRequest request) {
        return this.createUserMessageHandler.createRestorePasswordBid(rq, LinkGenerator.composeBaseUrl(request));
    }

    @Transactional
    @PostMapping(value={"/password/reset"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Reset password")
    public OperationCompletionRS resetPassword(@RequestBody @Validated ResetPasswordRQ rq) {
        return this.createUserMessageHandler.resetPassword(rq);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/password/reset/{uuid}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Check if a restore password bid exists")
    public YesNoRS isRestorePasswordBidExist(@PathVariable String uuid) {
        return this.createUserMessageHandler.isResetPasswordBidExist(uuid);
    }

    @Transactional
    @PostMapping(value={"/password/change"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Change own password")
    public OperationCompletionRS changePassword(@RequestBody @Validated ChangePasswordRQ changePasswordRQ, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.editUserMessageHandler.changePassword(currentUser, changePasswordRQ);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{userName}/projects"})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, UserResource.AssignedProject> getUserProjects(@PathVariable String userName, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.getUserHandler.getUserProjects(userName);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public Page<UserResource> findUsers(@RequestParam(value="term") String term, Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getUserHandler.searchUsers(term, pageable);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/export"})
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @Operation(summary="Exports information about all users", description="Allowable only for users with administrator role")
    public void export(@Parameter(schema=@Schema(allowableValues={"csv"})) @RequestParam(value="view", required=false, defaultValue="csv") String view, @FilterFor(value=User.class) Filter filter, @FilterFor(value=User.class) Queryable queryable, @AuthenticationPrincipal ReportPortalUser currentUser, HttpServletResponse response) {
        ReportFormat format = this.jasperReportHandler.getReportFormat(view);
        response.setContentType(format.getContentType());
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"RP_USERS_%s_Report.%s\"", format.name(), format.getValue()));
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.getUserHandler.exportUsers(format, (OutputStream)outputStream, (Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, queryable}));
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to write data to the response."});
        }
    }

    @PostMapping(value={"/{userId}/api-keys"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create new Api Key for current user")
    public ApiKeyRS createApiKey(@RequestBody @Validated ApiKeyRQ apiKeyRQ, @AuthenticationPrincipal ReportPortalUser currentUser, @PathVariable Long userId) {
        return this.apiKeyHandler.createApiKey(apiKeyRQ.getName(), currentUser.getUserId());
    }

    @DeleteMapping(value={"/{userId}/api-keys/{keyId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete specified Api Key")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')||hasPermission(#userId, 'allowedToOwner')")
    public OperationCompletionRS deleteApiKey(@PathVariable Long keyId, @PathVariable Long userId) {
        return this.apiKeyHandler.deleteApiKey(keyId, userId);
    }

    @GetMapping(value={"/{userId}/api-keys"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get List of users Api Keys")
    public ApiKeysRS getUsersApiKeys(@AuthenticationPrincipal ReportPortalUser currentUser, @PathVariable Long userId) {
        return this.apiKeyHandler.getAllUsersApiKeys(currentUser.getUserId());
    }
}

