/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.core.integration.ExecuteIntegrationHandler;
import com.epam.ta.reportportal.core.integration.plugin.GetPluginHandler;
import com.epam.ta.reportportal.core.integration.plugin.binary.PluginFilesProvider;
import com.epam.ta.reportportal.entity.attachment.BinaryData;
import com.epam.ta.reportportal.model.integration.IntegrationTypeResource;
import com.epam.ta.reportportal.util.BinaryDataResponseWriter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/plugin/public"})
@Tag(name="Plugin Public", description="Plugins Public API collection")
public class PluginPublicController {
    private final PluginFilesProvider pluginPublicFilesProvider;
    private final BinaryDataResponseWriter binaryDataResponseWriter;
    private final ExecuteIntegrationHandler executeIntegrationHandler;
    private final GetPluginHandler getPluginHandler;

    public PluginPublicController(PluginFilesProvider pluginPublicFilesProvider, BinaryDataResponseWriter binaryDataResponseWriter, ExecuteIntegrationHandler executeIntegrationHandler, GetPluginHandler getPluginHandler) {
        this.pluginPublicFilesProvider = pluginPublicFilesProvider;
        this.binaryDataResponseWriter = binaryDataResponseWriter;
        this.executeIntegrationHandler = executeIntegrationHandler;
        this.getPluginHandler = getPluginHandler;
    }

    @GetMapping(value={"/{pluginName}/file/{name}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get public plugin file without authentication")
    public void getPublicFile(@PathVariable(value="pluginName") String pluginName, @PathVariable(value="name") String fileName, HttpServletResponse response) {
        BinaryData binaryData = this.pluginPublicFilesProvider.load(pluginName, fileName);
        this.binaryDataResponseWriter.write(binaryData, response);
    }

    @PutMapping(value={"/{pluginName}/{command}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Execute public command without authentication")
    public Object executePublicPluginCommand(@PathVariable(value="pluginName") String pluginName, @PathVariable(value="command") String command, @RequestBody Map<String, Object> executionParams) {
        return this.executeIntegrationHandler.executePublicCommand(pluginName, command, executionParams);
    }

    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all available public plugins")
    public List<IntegrationTypeResource> getPlugins() {
        return this.getPluginHandler.getPublicPlugins();
    }
}

